'use strict';

// NOTE: Адаптивная высота элементов gallery-block
function resizeGallery() {
	var galleryItems = document.querySelectorAll('.gallery-block__item'); // берем коллекцию элементов
	let curWidth = galleryItems[0].offsetWidth; // берем высоту первого экземпляра

	Array.prototype.forEach.call(galleryItems, function (el, i) {	// задаем всем элементам высоту
		galleryItems[i].style.height = curWidth + 'px';
	});
}

window.onload = function () {
	if (document.querySelector('.gallery-block')) {
		resizeGallery();
	}
};

window.onresize = function () {
	if (document.querySelector('.gallery-block')) {
		resizeGallery();
	}
};

// modernizr wepb (для того, чтобы добавить фичи, нужно пересобрать modernizr-custom.js)
// Modernizr.on('webp', function (result) {		
// 	if (result) {
// 		console.log('Has WebP support'); 
// 	}
// 	else {
// 		console.log('No WebP support'); 
// 	}
// });

// NOTE: Parallax
if (document.querySelector('.goods-bg')) {
	document.addEventListener("DOMContentLoaded", function () {
		var scene = document.getElementById('goods');
		var parallaxInstance = new Parallax(scene, {
			frictionX: 0.02,
			frictionY: 0.07
		});
	});

	// Скрываем некоторые элементы фона при недостаточной высоте блока
	function hideVeggieItems() {
		var goodsListHeight = document.querySelector('.goods-list').offsetHeight;
		var goodsBgItems = document.querySelectorAll('#goods .wrapper');
		goodsBgItems = Array.prototype.slice.call(goodsBgItems);

		if (goodsListHeight < 700) {
			for (var i = 4; i < goodsBgItems.length; i++) {
				goodsBgItems[i].classList.add('hide');
			}
		} else {
			for (var i = 4; i < goodsBgItems.length; i++) {
				goodsBgItems[i].classList.remove('hide');
			}
		}
	}

	document.addEventListener("DOMContentLoaded", function () {
		hideVeggieItems();
	});
}

// NOTE: Selector
document.addEventListener("DOMContentLoaded", function () {
	tail.select("select");
});

// NOTE: Num stepper
function increaseValue(event) {
	var value = parseInt(event.currentTarget.parentNode.querySelector('input').value, 10);
	value = isNaN(value) ? 0 : value;
	value++;
	event.currentTarget.parentNode.querySelector('input').value = value;
}

function decreaseValue(event) {
	var value = parseInt(event.currentTarget.parentNode.querySelector('input').value, 10);
	value = isNaN(value) ? 0 : value;
	value--;
	if (value >= 0) {
		event.currentTarget.parentNode.querySelector('input').value = value;
	}
}

// NOTE: Cart. Remove item
function removeCartItem(event) {
	event.preventDefault();
	var currentElem = event.currentTarget.closest('.cart-row'); // TODO: не работает в IE	
	currentElem.parentNode.removeChild(currentElem);
}

// NOTE: Burger
function toggleMenu(event) {
	var btn = event.currentTarget;
	var menu = document.querySelector('#menu-top');
	var body = document.querySelector('body');

	if (event.currentTarget.classList.contains('active')) {
		body.style.overflow = '';
		menu.classList.remove('show');
		btn.classList.remove('active');
	} else {
		body.style.overflow = 'hidden';
		menu.classList.add('show');
		btn.classList.add('active');
	}
}

// NOTE: Ховер иконки в меню
(function menuIconHovering() {
	var filterElems = document.querySelectorAll('.filter_item');

	for (var i = 0; i < filterElems.length; i++) {
		filterElems[i].addEventListener("mouseover", function () {
			var currentIcon = this.getElementsByClassName('icon')[0];
			var currentSVG = currentIcon.contentDocument.getElementsByClassName('icon-menu')[0];
			currentSVG.style.stroke = '#ffffff';
			currentSVG.style.strokeWidth = '0.5';
		});
	}

	for (var i = 0; i < filterElems.length; i++) {
		filterElems[i].addEventListener("mouseout", function () {
			var currentIcon = this.getElementsByClassName('icon')[0];
			var currentSVG = currentIcon.contentDocument.getElementsByClassName('icon-menu')[0];
			currentSVG.style.stroke = '';
			currentSVG.style.strokeWidth = '';
		});
	}
})();

// NOTE: Слайдер
document.addEventListener("DOMContentLoaded", function () {
	if (document.querySelector('.top-slider')) {
		objectFitImages(); // Object-fit IE

		var slider = tns({
			container: '.top-slider',
			mode: 'carousel',
			axis: 'horizontal',
			items: 1,
			nav: false,
			controls: false,
			loop: true,
			autoplay: true,
			speed: 600,
			autoplayTimeout: 4000,
			autoplayHoverPause: true,
			autoplayButton: false,
			autoplayButtonOutput: false,
			touch: true,
			mouseDrag: false
		});
	}
});
