<?php

function drk_venders_custom_post_type() {
	$labels = array(
		'name'               => __( 'Venders' ),
		'singular_name'      => __( 'Vender' ),
		'menu_name'          => __( 'Venders' ),
		'all_items'          => __( 'All Venders' ),
		'view_item'          => __( 'View Vender' ),
		'add_new_item'       => __( 'Add Vender' ),
		'add_new'            => __( 'Add Vender' ),
		'edit_item'          => __( 'Edit Vender' ),
		'update_item'        => __( 'Update Vender' ),
		'search_items'       => __( 'Search Vender' ),
		'not_found'          => __( 'Not Found' ),
		'not_found_in_trash' => __( 'Not found in Trash' )
	);
	$args   = array(
		'label'               => __( 'Venders' ),
		'description'         => __( 'Venders' ),
		'labels'              => $labels,
		'supports'            => array(
			'title',
			'editor',
			'author',
			'thumbnail',
			'custom-fields',
			'taxonomies',
			'excerpt',
            'comments'

		),
		'public'              => true,
		'hierarchical'        => false,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'has_archive'         => false,
		'can_export'          => false,
		'exclude_from_search' => false,
		'yarpp_support'       => true,
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'taxonomies'          => array('post_tag'),
		'menu_position' => 5,
		'menu_icon' => "dashicons-building",
		'show_in_rest'       => true

	);
	register_post_type( 'venders', $args );
}

add_action( 'init', 'drk_venders_custom_post_type', 0 );