<?php

function drk_tutorials_custom_post_type() {
	$labels = array(
		'name'               => __( 'Tutorials' ),
		'singular_name'      => __( 'Tutorial' ),
		'menu_name'          => __( 'Tutorials' ),
		'all_items'          => __( 'All Tutorial' ),
		'view_item'          => __( 'View Tutorial' ),
		'add_new_item'       => __( 'Add Tutorial' ),
		'add_new'            => __( 'Add Tutorial' ),
		'edit_item'          => __( 'Edit Tutorial' ),
		'update_item'        => __( 'Update Tutorial' ),
		'search_items'       => __( 'Search Tutorial' ),
		'not_found'          => __( 'Not Found' ),
		'not_found_in_trash' => __( 'Not found in Trash' )
	);
	$args   = array(
		'label'               => __( 'tutorial' ),
		'description'         => __( 'Tutorials' ),
		'labels'              => $labels,
		'supports'            => array(
			'title',
			'editor',
			'author',
			'thumbnail',
			'comments',
			'taxonomies',
			'excerpt'
		),
		'public'              => true,
		'hierarchical'        => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'has_archive'         => false,
		'can_export'          => false,
		'exclude_from_search' => false,
		'yarpp_support'       => true,
		'taxonomies'          => array('post_tag','category'),
		'publicly_queryable'  => false,
		'capability_type'     => 'post',
		'menu_position'       => 5,
		'menu_icon'           => 'dashicons-welcome-learn-more',
		'show_in_rest'       => true


	);
	register_post_type( 'tutorials', $args );
}

add_action( 'init', 'drk_tutorials_custom_post_type', 0);

?>