<?php

function drk_news_custom_post_type() {
	$labels = array(
		'name'               => __( 'News' ),
		'singular_name'      => __( 'News' ),
		'menu_name'          => __( 'News' ),
		'all_items'          => __( 'All News' ),
		'view_item'          => __( 'View News' ),
		'add_new_item'       => __( 'Add News' ),
		'add_new'            => __( 'Add News' ),
		'edit_item'          => __( 'Edit News' ),
		'update_item'        => __( 'Update News' ),
		'search_items'       => __( 'Search News' ),
		'not_found'          => __( 'Not Found' ),
		'not_found_in_trash' => __( 'Not found in Trash' )
	);
	$args   = array(
		'label'               => __( 'news' ),
		'description'         => __( 'News of all ' ),
		'labels'              => $labels,
		'supports'            => array(
			'title',
			'editor',
			'author',
			'thumbnail',
			'comments',
			'taxonomies',
			'excerpt'
		),
		'public'              => true,
		'hierarchical'        => false,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'has_archive'         => false,
		'can_export'          => false,
		'exclude_from_search' => false,
		'yarpp_support'       => true,
		'taxonomies'          => array('post_tag','isHot'),
		'publicly_queryable'  => false,
		'capability_type'     => 'post',
		'menu_position'       => 5,
		'menu_icon'           => 'dashicons-text-page',
		'show_in_rest'       => true


	);
	register_post_type( 'news', $args );
}

add_action( 'init', 'drk_news_custom_post_type', 0);

?>