<?php

function drk_markets_custom_post_type() {
	$labels = array(
		'name'               => __( 'Markets' ),
		'singular_name'      => __( 'Market' ),
		'menu_name'          => __( 'Markets' ),
		'all_items'          => __( 'All Markets' ),
		'view_item'          => __( 'View Market' ),
		'add_new_item'       => __( 'Add Market' ),
		'add_new'            => __( 'Add Market' ),
		'edit_item'          => __( 'Edit Market' ),
		'update_item'        => __( 'Update Market' ),
		'search_items'       => __( 'Search Market' ),
		'not_found'          => __( 'Not Found' ),
		'not_found_in_trash' => __( 'Not found in Trash' )
	);
	$args   = array(
		'label'               => __( 'markets' ),
		'description'         => __( 'Markets' ),
		'labels'              => $labels,
		'supports'            => array(
			'title',
			'editor',
			'author',
			'thumbnail',
			'taxonomies',
			'excerpt',
            'comments'
		),
		'public'              => true,
		'hierarchical'        => false,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'has_archive'         => false,
		'can_export'          => false,
		'exclude_from_search' => false,
		'yarpp_support'       => true,
		'taxonomies'          => array( 'post_tag' ),
		'publicly_queryable'  => true,
		'capability_type'     => 'post',
		'menu_position' => 6,
		'menu_icon' => 'dashicons-store',
		'show_in_rest'       => true
	);
	register_post_type( 'markets', $args );
}

add_action( 'init', 'drk_markets_custom_post_type', 0 );