<?php

function drk_forum_custom_post_type() {
	$labels = array(
		'name'               => __( 'Forum' ),
		'singular_name'      => __( 'Forum' ),
		'menu_name'          => __( 'Forum' ),
		'all_items'          => __( 'All Topics' ),
		'view_item'          => __( 'View Topic' ),
		'add_new_item'       => __( 'Add Topic' ),
		'add_new'            => __( 'Add Topic' ),
		'edit_item'          => __( 'Edit Topic' ),
		'update_item'        => __( 'Update Topic' ),
		'search_items'       => __( 'Search Topic' ),
		'not_found'          => __( 'Not Found' ),
		'not_found_in_trash' => __( 'Not found in Trash' )
	);
	$args   = array(
		'label'               => __( 'forum' ),
		'description'         => __( 'Forum' ),
		'labels'              => $labels,
		'supports'            => array(
			'title',
			'editor',
			'author',
			'thumbnail',
			'taxonomies',
			'excerpt',
            'comments'
		),
		'public'              => true,
		'hierarchical'        => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'has_archive'         => false,
		'can_export'          => false,
		'exclude_from_search' => false,
		'yarpp_support'       => true,
		'taxonomies'          => array( 'post_tag','category'),
		'publicly_queryable'  => false,
		'capability_type'     => 'post',
		'menu_position' => 6,
		'menu_icon' => 'dashicons-groups',
		'show_in_rest'       => true,
        'rewrite' => array( 'slug' => 'forum' ),
	);
	register_post_type( 'forum', $args );
}

add_action( 'init', 'drk_forum_custom_post_type', 0 );