<?php
function drk_user_profile_link(WP_User $user)
{
    ?>
    <h3>User profile id:</h3>
        <?php
    $args = array(
        'post_type'=>'profile',
        'meta_key' => '_user_id',
        'meta_query' => array(
            array(
                'key' => '_user_id',
                'value' => $user->ID,
                'compare' => '=',
            )
        )
    );
    $query = new WP_Query($args);
    $profile = $query->post;
    if(!$profile->ID){
        $profile = drk_create_user_profile($user);
    }
    echo "<a href='".get_site_url()."/wp-admin/post.php?post=".$profile->ID."&action=edit'>Profile #".$profile->ID."</a>";
}
add_action('show_user_profile', 'drk_user_profile_link');
add_action('edit_user_profile', 'drk_user_profile_link');

add_action('show_user_profile', 'drk_2fe_otp_user_fields');
add_action('edit_user_profile', 'drk_2fe_otp_user_fields');

function drk_2fe_otp_user_fields($user)
{
    $is_otp_active = get_the_author_meta('drk_otp_is_active', $user->ID);
    $secret = get_the_author_meta('user_otp_secret', $user->ID);
    if(strlen($secret) == 0 && $is_otp_active!="true"){
        $secret = drk_generate_otp_code();
        update_user_meta($user->ID, 'user_otp_secret', $secret);
    }
    ?>
    <h3>OTP 2FA</h3>

    <table class="form-table">
        <tr>
            <th><label for="drk_otp_is_active">User otp secret is active:</label></th>
            <td>
                <input onchange="DrkCheckOtpActive(this)" type="checkbox" id="drk_otp_is_active"
                       name="drk_otp_is_active"
                       value="<?php echo $is_otp_active === "true" ? 'true' : 'false' ?>"
                    <?php echo $is_otp_active === "true" ? " checked='checked' " : ""; ?> />
            </td>
        </tr>
        <tr>
            <th><label for="drk_otp_is_active">User otp secret:</label></th>
            <td>
                <input id="otp-secret1" name="user_otp_secret" type="text" value="<?php
                echo $secret ? $secret : ''; ?>"/>
            </td>
        </tr>
            <?php if(!$is_otp_active){?>
        <tr>
            <th><label for="drk_qrcode">User otp QR code:</label></th>
            <td><?php print_r(drk_get_otp_qrcode_admin($user))?></td>
        </tr><?php }?>
    </table>
    <hr/>
    <script>
        let is_otp_active = document.getElementById('drk_otp_is_active');
        if (is_otp_active.checked) {
            is_otp_active.value = true;
        } else
            is_otp_active.value = false;

        function DrkCheckOtpActive() {
            let is_otp_active = document.getElementById('drk_otp_is_active');
            if (is_otp_active.checked === true) {
                is_otp_active.value = true;
            } else {
                is_otp_active.value = false;
            }
        }
    </script>
<?php }

add_action('personal_options_update', 'save_2fe_otp_user_fields');
add_action('edit_user_profile_update', 'save_2fe_otp_user_fields');
function save_2fe_otp_user_fields($user_id)
{
    if (!current_user_can('edit_user', $user_id)) return false;

    if (isset($_POST['drk_otp_is_active']) && $_POST['drk_otp_is_active'] != "") {
        update_user_meta($user_id, 'drk_otp_is_active', $_POST['drk_otp_is_active']);
    } else {
        delete_user_meta($user_id, 'drk_otp_is_active', false);
    }

}

add_action('show_user_profile', 'drk_2fe_email_user_fields');
add_action('edit_user_profile', 'drk_2fe_email_user_fields');
function drk_2fe_email_user_fields($user)
{
    $otp_email_is_enabled = get_the_author_meta('drk_email_otp_enabled', $user->ID);
    ?>
    <h3>Email 2FA:</h3>
    <table class="form-table">
        <tr>
            <th><label for="otp-secret">User otp enabled</label></th>
            <td>
                <input onchange="DrkOtpEmailChecker(this)" type="checkbox" id="drk_email_otp_enabled"
                       name="drk_email_otp_enabled"
                       value="<?php echo $otp_email_is_enabled === "true" ? 'true' : 'false' ?>"
                    <?php echo $otp_email_is_enabled === "true" ? " checked='checked' " : ""; ?> />
            </td>
        </tr>
        <tr>
            <th><label for="otp-secret">User otp code</label></th>
            <td>
                <input id="otp-secret" name="user_otp_mail_code" type="text" value="<?php
                $enable = get_the_author_meta('user_otp_mail_code', $user->ID);
                echo $enable ? $enable : ''; ?>"/>
            </td>
        </tr>
    </table>
    <hr/>
<?php }

add_action('personal_options_update', 'save_2fe_email_user_fields');
add_action('edit_user_profile_update', 'save_2fe_email_user_fields');
function save_2fe_email_user_fields($user_id)
{
    if (!current_user_can('edit_user', $user_id)) return false;

    if (isset($_POST['user_otp_mail_code']) && $_POST['user_otp_mail_code'] != "") {
        update_user_meta($user_id, 'user_otp_mail_code', $_POST['user_otp_mail_code']);
    }else{
        delete_user_meta($user_id, 'user_otp_mail_code', '');
    }
}

add_action('show_user_profile', 'drk_email_is_confirmed_fields');
add_action('edit_user_profile', 'drk_email_is_confirmed_fields');

function drk_email_is_confirmed_fields($user)
{
    $is_confirmed = get_the_author_meta('drk_email_is_confirmed', $user->ID);
    $confirmation_code = get_the_author_meta('drk_email_confirmation_code', $user->ID);
    ?>
    <h3>Email confirmation:</h3>

    <table class="form-table">
        <tr>
            <th><label for="otp-secret">Email is confirmed:</label></th>
            <td>
                <input onchange="DrkCheckChecker(this)" type="checkbox" id="drk_email_is_confirmed"
                       name="drk_email_is_confirmed"
                       value="<?php echo $is_confirmed === "true" ? 'true' : 'false' ?>"
                    <?php echo $is_confirmed === "true" ? " checked='checked' " : ""; ?> />
            </td>
        </tr>
        <tr>
            <th><label for="otp-secret">Confirmation code:</label></th>
            <td>
                <input type="text" id="drk_email_confirmation_code"
                       name="drk_email_confirmation_code"
                       value="<?php echo $confirmation_code; ?>"/>
            </td>
        </tr>
    </table>
    <script>
        let is_verified_email = document.getElementById('drk_email_is_confirmed');
        if (is_verified_email.checked) {
            is_verified_email.value = true;
        } else
            is_verified_email.value = false;

        let is_email_otp_enabled = document.getElementById('drk_email_otp_enabled');
        if (is_email_otp_enabled.checked) {
            is_email_otp_enabled.value = true;
        } else
            is_email_otp_enabled.value = false;

        function DrkCheckChecker(element) {
            if (element.checked) {
                element.value = true;
            } else {
                element.value = false;
            }
        }
        function DrkOtpEmailChecker(element) {
            if (element.checked) {
                element.value = true;
            } else {
                element.value = false;
            }
        }

    </script>
<?php }

add_action('personal_options_update', 'save_email_is_confirmed_fields');
add_action('edit_user_profile_update', 'save_email_is_confirmed_fields');
function save_email_is_confirmed_fields($user_id)
{
    if (!current_user_can('edit_user', $user_id)) return false;

    if (isset($_POST['drk_email_is_confirmed']) && $_POST['drk_email_is_confirmed'] != "") {
        update_user_meta($user_id, 'drk_email_is_confirmed', $_POST['drk_email_is_confirmed']);
    } else {
        update_user_meta($user_id, 'drk_email_is_confirmed', false);
    }
    if (isset($_POST['drk_email_otp_enabled']) && $_POST['drk_email_otp_enabled'] != "") {
        update_user_meta($user_id, 'drk_email_otp_enabled', $_POST['drk_email_otp_enabled']);
    } else {
        update_user_meta($user_id, 'drk_email_otp_enabled', false);
    }
    if (isset($_POST['drk_email_confirmation_code']) && $_POST['drk_email_confirmation_code'] != "") {
        update_user_meta($user_id, 'drk_email_confirmation_code', $_POST['drk_email_confirmation_code']);
    } else {
        update_user_meta($user_id, 'drk_email_confirmation_code', false);
    }
}

add_action('show_user_profile', 'drk_pgp_is_enabled_fields');
add_action('edit_user_profile', 'drk_pgp_is_enabled_fields');
function drk_pgp_is_enabled_fields($user)
{
    $pgp_is_enabled = get_the_author_meta('drk_pgp_is_enabled', $user->ID);
    $public_key = get_the_author_meta('drk_pgp_public_key', $user->ID);
    $confirmation_code = get_the_author_meta('drk_pgp_confirmation_code', $user->ID);
    ?>
    <h3>PGP 2FA:</h3>

    <table class="form-table">
        <tr>
            <th><label for="otp-secret">PGP 2FA is enabled:</label></th>
            <td>
                <input onchange="DrkCheckChecker(this)" type="checkbox" id="drk_pgp_is_enabled"
                       name="drk_pgp_is_enabled"
                       value="<?php echo $pgp_is_enabled === "true" ? 'true' : 'false' ?>"
                    <?php echo $pgp_is_enabled === "true" ? " checked='checked' " : ""; ?> />
            </td>
        </tr>
        <tr>
            <th><label for="drk_pgp_public_key">Public key:</label></th>
            <td>
                <textarea
                        rows="12"
                        id="drk_pgp_public_key"
                       name="drk_pgp_public_key"
                ><?php echo $public_key; ?></textarea>
            </td>
        </tr>
        <tr>
            <th><label for="drk_pgp_confirmation_code">Confirmation code:</label></th>
            <td>
                <input type="text" id="drk_pgp_confirmation_code"
                       name="drk_pgp_confirmation_code"
                       value="<?php echo $confirmation_code; ?>"/>
            </td>
        </tr>
    </table>
    <script>
        let is_verified_pgp = document.getElementById('drk_pgp_is_enabled');
        if (is_verified_pgp.checked) {
            is_verified_pgp.value = true;
        } else
            is_verified_pgp.value = false;
    </script>
<?php }

add_action('personal_options_update', 'save_pgp_is_confirmed_fields');
add_action('edit_user_profile_update', 'save_pgp_is_confirmed_fields');
function save_pgp_is_confirmed_fields($user_id)
{
    if (!current_user_can('edit_user', $user_id)) return false;

    if (isset($_POST['drk_pgp_is_enabled']) && $_POST['drk_pgp_is_enabled'] != "") {
        update_user_meta($user_id, 'drk_pgp_is_enabled', $_POST['drk_pgp_is_enabled']);
    } else {
        update_user_meta($user_id, 'drk_pgp_is_enabled', false);
    }
    if (isset($_POST['drk_pgp_public_key']) && $_POST['drk_pgp_public_key'] != "") {
        update_user_meta($user_id, 'drk_pgp_public_key', $_POST['drk_pgp_public_key']);
    } else {
        update_user_meta($user_id, 'drk_pgp_public_key', false);
    }
    if (isset($_POST['drk_pgp_confirmation_code']) && $_POST['drk_pgp_confirmation_code'] != "") {
        update_user_meta($user_id, 'drk_pgp_confirmation_code', $_POST['drk_pgp_confirmation_code']);
    } else {
        update_user_meta($user_id, 'drk_pgp_confirmation_code', false);
    }
}