<?php
function drk_generate_users_profile()
{
    $users = get_users();
    foreach ($users as $user) {
        $post_arr = array(
            "post_author" => $user->data->ID,
            "post_title" => $user->data->user_login,
            "post_content" => '',
            "post_type" => "profile",
            "post_status" => 'publish',
            "comment_status" => "open",
            "meta_input" => array(
                "_user_id" => $user->data->ID
            )
        );

        if (count(get_posts(array('post_type' => "profile", "meta_key" => "_user_id", "meta_value" => $user->data->ID))) == 0) {
            wp_insert_post($post_arr, false, true);
        }
    }
}

function drk_create_user_profile(WP_User $user)
{
    $post_arr = array(
        "post_author" => $user->data->ID,
        "post_title" => $user->data->user_login,
        "post_content" => '',
        "post_type" => "profile",
        "post_status" => 'publish',
        "comment_status" => "open",
        "meta_input" => array(
            "_user_id" => $user->ID
        )
    );
    if (count(get_posts(array('post_type' => "profile", "meta_key" => "_user_id", "meta_value" => $user->data->ID))) == 0) {
        $profile_id = wp_insert_post($post_arr, false, true);
        return get_post($profile_id);
    }else{
        return false;
    }
}

function drk_get_user_profile_id($user_id)
{
    $profile_post = get_posts(array('post_type' => "profile", "author" => $user_id, 'fields' => "_user_id"));
    return $profile_post[0]->ID;
}

function drk_get_user_profile($user_array)
{
    if($user_array['ID']){
        $user_id = $user_array['ID'];
    }elseif($user_array['id']){
        $user_id = $user_array['id'];
    }else{
        return false;
    }


    $profile_post = get_posts(array('post_type' => "profile", "author" => $user_id, 'fields' => "_user_id"));
    $profile["profile_id"] = $profile_post[0]->ID;

    $args = array(
        'parent' => 0,
        'post_type' => "profile",
        'post_id' => $profile["profile_id"]
    );
    $profile["comments"] = get_comments($args);
    $profile['avatar'] = drk_get_user_avatar_from_profile($user_id);
    return $profile;
}

function drk_get_user_forum_tickets_count($user)
{
    return (integer)count_user_posts($user['id'], "forum", false);
}

function drk_get_user_forum_comments_count($user)
{
    $user = get_user_by('ID', $user['id']);
    return get_comments(array('author_email' => $user->user_email, 'count' => true, 'post_type' => 'forum', 'fields' => 'count'));
}

function drk_get_user_rate($vuser, $attr, $request)
{
    $token = drk_get_header_bearer_token($request);
    $user_id = drk_get_user_id_from_token($token);
    return drk_get_users_votes($user_id,$vuser["id"]);
}

function drk_compile_post_type_capabilities($singular = 'profile', $plural = 'profiles') {
    return array(
        'edit_post'		 => "edit_$singular",
        'read_post'		 => "read_$singular",
        'delete_post'		 => "delete_$singular",
        'edit_posts'		 => "edit_$plural",
        'edit_others_posts'	 => "edit_others_$plural",
        'publish_posts'		 => "publish_$plural",
        'read_private_posts'	 => "read_private_$plural",
        'read'                   => "read",
        'delete_posts'           => "delete_$plural",
        'delete_private_posts'   => "delete_private_$plural",
        'delete_published_posts' => "delete_published_$plural",
        'delete_others_posts'    => "delete_others_$plural",
        'edit_private_posts'     => "edit_private_$plural",
        'edit_published_posts'   => "edit_published_$plural",
        'create_posts'           => "create_$plural",
        //'moderate_comments'			=> "moderate_$plural_comments",
    );
}

function drk_get_user_avatar_from_profile($user_id)
{
    $default_image = site_url()."/wp-content/plugins/darkey-plugin/files/default-image.jpg";
    $profile_id = drk_get_user_profile_id($user_id);

    if(has_post_thumbnail($profile_id) == false)
        return $default_image;
    return get_the_post_thumbnail_url($profile_id,'profile-thumb');
}