<?php

/* Additional fields*/

function drk_get_user_roles($object, $field_name, $request) {
    return get_userdata($object['id'])->roles;
}

add_action('rest_api_init', function() {
    register_rest_field('user', 'user_role', array(
        'get_callback' => 'drk_get_user_roles',
        'update_callback' => null,
        'schema' => array(
            'type' => 'array'
        )
    ));
});

function drk_get_user_register_date($object, $field_name, $request) {
    return get_userdata($object['id'])->user_registered;
}

add_action('rest_api_init', function() {
    register_rest_field('user', 'user_registered', array(
        'get_callback' => 'drk_get_user_register_date',
        'update_callback' => null,
        'permission_callback' => '__return_true',
    ));
});

function drk_get_user_nikname($object, $field_name, $request) {
    return get_userdata($object['id'])->nickname;
}

add_action('rest_api_init', function() {
    register_rest_field('user', 'user_nikname', array(
        'get_callback' => 'drk_get_user_nikname',
        'update_callback' => null,
        'permission_callback' => '__return_true',
    ));
});


add_action('rest_api_init', function() {
    register_rest_field('user', 'user_forum_tickets', array(
        'get_callback' => 'drk_get_user_forum_tickets_count',
        'update_callback' => null,
        'permission_callback' => '__return_true',
    ));
});

add_action('rest_api_init', function() {
    register_rest_field('user', 'user_forum_messages', array(
        'get_callback' => 'drk_get_user_forum_comments_count',
        'update_callback' => null,
        'permission_callback' => '__return_true',
    ));
});

add_action('rest_api_init', function() {
    register_rest_field('user', 'user_profile_rate', array(
        'get_callback' => 'drk_get_user_rate',
        'update_callback' => null,
        'permission_callback' => '__return_true',
    ));
});

add_action('rest_api_init', function() {
    register_rest_field('user', 'user_online', array(
        'get_callback' => function(){return true;},
        'update_callback' => null,
        'permission_callback' => '__return_true',
    ));
});

add_action('rest_api_init', function() {
    register_rest_field('user', 'user_profile', array(
        'get_callback' => 'drk_get_user_profile',
        'update_callback' => null,
        'permission_callback' => '__return_true',
    ));
});

/*API endpoints*/
function drk_get_user_forum_comments(WP_REST_Request $request){
    $user = get_user_by('ID',$request['user_id']);
    $comments = get_comments(array('author_email'=> $user->data->user_email,'post_type' => 'forum', 'fields'=> 'all'));
    foreach($comments as $key=>$comment){
        $user_id = $comment->user_id;
        $avatar = drk_get_user_avatar_from_profile($user_id);
        $comment->_user_avatar = $avatar;
        $comment->_user_roles = get_userdata($user_id)->roles;
        $comment->user_caps = get_userdata($user_id)->allcaps;
    }
    return $comments;
}

add_action( 'rest_api_init', function () {
    register_rest_route( 'wp/v2', '/forum/comments/', array(
        'methods' => 'GET',
        'callback' => 'drk_get_user_forum_comments',
        'permission_callback' => '__return_true',
    ) );
} );

function drk_get_user_tutorials_comments(WP_REST_Request $request){
    $user = get_user_by('ID',$request['user_id']);
    $comments = get_comments(array('author_email'=> $user->data->user_email,'post_type' => 'tutorials', 'fields'=> 'all'));
    foreach($comments as $key=>$comment){
        $user_id = $comment->user_id;
        $avatar = drk_get_user_avatar_from_profile($user_id);
        $comment->_user_avatar = $avatar;
        $comment->_user_roles = get_userdata($user_id)->roles;
        $comment->user_caps = get_userdata($user_id)->allcaps;
    }

    return $comments;
}

add_action( 'rest_api_init', function () {
    register_rest_route( 'wp/v2', '/tutorials/comments/', array(
        'methods' => 'GET',
        'callback' => 'drk_get_user_tutorials_comments',
        'permission_callback' => '__return_true',
    ) );
} );

function drk_get_user_news_comments(WP_REST_Request $request){
    $user = get_user_by('ID',$request['user_id']);
    $comments = get_comments(array('author_email'=> $user->data->user_email,'post_type' => 'news', 'fields'=> 'all'));
    foreach($comments as $key=>$comment){
        $user_id = $comment->user_id;
        $avatar = drk_get_user_avatar_from_profile($user_id);
        $comment->_user_avatar = $avatar;
        $comment->_user_roles = get_userdata($user_id)->roles;
        $comment->user_caps = get_userdata($user_id)->allcaps;
    }
    return $comments;
}

add_action( 'rest_api_init', function () {
    register_rest_route( 'wp/v2', '/news/comments/', array(
        'methods' => 'GET',
        'callback' => 'drk_get_user_news_comments',
        'permission_callback' => '__return_true',
    ) );
} );

function drk_get_user_profile_comments(WP_REST_Request $request){
    $user_id = $request->get_param('user_id');
    $profile_id = drk_get_user_profile_id($user_id);
    $comments = get_comments(array('post_id'=> $profile_id,'post_type' => 'profile', 'fields'=> 'all'));
    foreach($comments as $key=>$comment){
        $user_id = $comment->user_id;
        $avatar = drk_get_user_avatar_from_profile($user_id);
        $comment->_user_avatar = $avatar;
        $comment->_user_roles = get_userdata($user_id)->roles;
        $comment->user_caps = get_userdata($user_id)->allcaps;
    }
    return $comments;
}

add_action( 'rest_api_init', function () {
    register_rest_route( 'wp/v2', '/profile/comments/', array(
        'methods' => 'GET',
        'callback' => 'drk_get_user_profile_comments',
        'permission_callback' => '__return_true',
    ) );
} );