<?php
// Add Meta Box to post
add_action( 'add_meta_boxes', 'drk_audio_uploader_meta_box' );

function drk_audio_uploader_meta_box() {
	add_meta_box( 
		'audio-meta-box', 
		'Audio',
		'drk_audio_uploader_meta_box_func', 
		array("forum"), 
		'normal', 
		'high' );
}

function drk_audio_uploader_meta_box_func($post) {
	$audio = get_post_meta($post->ID,'_audio',true);
	?>
	<style type="text/css">
		.multi-upload-medias ul li .delete-img { position: absolute; right: 3px; top: 2px; background: aliceblue; border-radius: 50%; cursor: pointer; font-size: 14px; line-height: 20px; color: red; }
		.multi-upload-medias ul li { width: 120px; display: inline-block; vertical-align: middle; margin: 5px; position: relative; }
		.multi-upload-medias ul li img { width: 100%; }
	</style>

	<table cellspacing="10" cellpadding="10">
		<tr>
			<td>Add audio</td>
			<td>
				<?php echo drk_audio_uploader_field( '_audio', $audio ); ?>
			</td>
		</tr>
	</table>

	<script type="text/javascript">
		jQuery(function($) {

			$('body').on('click', '.drk_audio_upload_button', function(e) {
				e.preventDefault();
				var button = $(this),
				custom_uploader = wp.media({
					title: 'Insert audio',
					button: { text: 'Use this audio' },
					multiple: false,
					library: { type: ['audio']},
				}).on('select', function() {
					var attech_ids = '';
					//attachments
					var attachments = custom_uploader.state().get('selection'),
					attachment_ids = new Array(),
					i = 0;
					attachments.each(function(attachment) {
						attachment_ids[i] = attachment['id'];
						attech_ids += ',' + attachment['id'];
						console.log(attachment.attributes.type);
						if(attachment.attributes.type == 'audio')
							$(button).siblings('ul').append('<audio controls><source src="'+ attachment.attributes.url +'" type="audio/mpeg">Your browser does not support the audio tag.</audio><i class=" dashicons dashicons-no delete-img"></i>');
						i++;
					});

					var ids = $(button).siblings('.attechments-ids').attr('value');
					if (ids) {
						var ids = ids + attech_ids;
						$(button).siblings('.attechments-ids').attr('value', ids);
					} else {
						$(button).siblings('.attechments-ids').attr('value', attachment_ids);
					}
					$(button).siblings('.drk_multi_remove_audio_button').show();
				})
				.open();
			});

			$('body').on('click', '.drk_multi_remove_audio_button', function() {
				$(this).hide().prev().val('').prev().addClass('button').html('Add audio');
				$(this).parent().find('ul').empty();
				return false;
			});

		});

		jQuery(document).ready(function() {
			jQuery(document).on('click', '.multi-upload-medias ul li i.delete-img', function() {
				var ids = [];
				var this_c = jQuery(this);
				jQuery(this).parent().remove();
				jQuery('.multi-upload-medias ul li').each(function() {
					ids.push(jQuery(this).attr('data-attechment-id'));
				});
				jQuery('.multi-upload-medias').find('input[type="hidden"]').attr('value', ids);
			});
		})
	</script>

	<?php
}


function drk_audio_uploader_field($name, $value = '') {
	$audio = '">Add audio';
	$audio_str = '';
	$audio_size = 'full';
	$display = 'none';
	if (!empty($value)) {
			if ($audio_attributes = wp_get_attachment_url($value) ) {
				$audio_str .= "<audio controls><source src='"
				.$audio_attributes.
				"' type='audio/mpeg'>Your browser does not support the audio tag.</audio>";
			}
	}

	if($audio_str){
		$display = 'inline-block';
	}

	return '<div class="multi-upload-medias"><ul>' . $audio_str . '</ul><a href="#" class="drk_audio_upload_button button' 
	. $audio . '</a><input type="hidden" class="attechments-ids ' . $name . '" name="' . $name . '" id="' . $name . '" value="' 
	. esc_attr($value) . '" /><a href="#" class="drk_multi_remove_audio_button button" style="display:inline-block;display:'
	. $display . '">Remove audio</a></div>';
}

// Save Meta Box values.
add_action( 'save_post', 'drk_audio_meta_box_save' );

function drk_audio_meta_box_save() {
    global $post;
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;	
	}
	
	if( isset( $_POST['_audio']) && $_POST['_audio']!="" ){
		update_post_meta( $post->ID, '_audio', $_POST['_audio'] );
	}else{
        delete_post_meta( $post->ID, '_audio', "" );
    }
}