<?php

function drk_get_2fa_type(WP_User $user){

    $otp_is_enable = get_user_meta($user->ID, 'drk_otp_is_active', true);
    $email_is_enable = get_user_meta($user->ID, 'drk_email_otp_enabled', true);
    $pgp_is_enable = get_user_meta($user->ID, 'drk_pgp_is_enabled', true);
    if($otp_is_enable == "true") return "Auth";
    if($email_is_enable == "true" ) return "Email";
    if($pgp_is_enable == "true") return "PGP";
    return false;
}

function drk_enable_2fa_otp(WP_User $user){
    update_user_meta($user->ID, 'drk_otp_is_active', "true");

    delete_user_meta($user->ID, 'user_otp_mail_code', '');
    delete_user_meta($user->ID, 'drk_email_otp_enabled', 'false');
    delete_user_meta($user->ID, 'drk_pgp_is_enabled', '');
    delete_user_meta($user->ID, 'drk_pgp_confirmation_code', '');
}

function drk_enable_2fa_pgp(WP_User $user){
    update_user_meta($user->ID, 'drk_pgp_is_enabled', "true");

    delete_user_meta($user->ID, 'user_otp_mail_code', '');
    delete_user_meta($user->ID, 'drk_email_otp_enabled', '');
    delete_user_meta($user->ID, 'user_otp_secret', '');
    delete_user_meta($user->ID, 'drk_otp_is_active', '');
    delete_user_meta($user->ID, 'drk_pgp_confirmation_code', '');
}

function drk_enable_2fa_email(WP_User $user, $verify_code){
    update_user_meta($user->ID, 'user_otp_mail_code', $verify_code);
    update_user_meta($user->ID, 'drk_email_otp_enabled', "true");

    delete_user_meta($user->ID, 'drk_pgp_is_enabled', "");
    delete_user_meta($user->ID, 'drk_pgp_confirmation_code', "");
    delete_user_meta($user->ID, 'drk_otp_is_active', "");
    delete_user_meta($user->ID, 'user_otp_secret', "");
}