<?php
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function drk_get_token($login_data)
{

    $site_url = get_site_url();

    if ($_SERVER['SERVER_NAME'] == 'localhost') {

        $site_url = "http://" . $_SERVER['SERVER_ADDR'] . ":" . $_SERVER["SERVER_PORT"];
    }
    $http_client = new WP_Http();
    $args = array(
        'method' => 'POST',
        'body' => $login_data
    );

    return $http_client->request($site_url . '/wp-json/jwt-auth/v1/token', $args);
}

function drk_validate_token($token, $user_id)
{
    $user = null;
    $site_url = get_site_url();
    if ($_SERVER['SERVER_NAME'] == 'localhost') {
        $site_url = "http://" . $_SERVER['SERVER_ADDR'] . ":" . $_SERVER["SERVER_PORT"];
    }
    $http_client = new WP_Http();
    $args = array(
        'method' => 'POST',
        'headers' => array(
            'Authorization' => "Bearer " . $token,
        ),
    );
    $data = $http_client->request($site_url . '/wp-json/jwt-auth/v1/token/validate', $args);
    if (json_decode($data["body"])->data->status != 200)
        return false;
    if ($user_id == null) {
        $user_id = drk_get_user_id_from_token($token);
        $user = get_user_by('id',$user_id);
        if ($user->data->ID === null) {
            return false;
        }
    }
    $user = get_userdata($user_id);

    if ($user == null) {
        return false;
    }

    $roles = $user->get_role_caps();
    $twoFa = false;
    $twoFaAuth = get_the_author_meta('drk_otp_is_active', $user->data->ID);
    $twoFaEmail = get_the_author_meta('user_otp_mail_code', $user->data->ID);
    $twoFaPGP = get_the_author_meta('drk_pgp_is_enabled', $user->data->ID);
    $email_is_confirmed = get_the_author_meta('drk_email_is_confirmed', $user->data->ID);
    $profile = drk_get_user_profile((array)$user->data);
    if (strlen(trim($twoFaAuth)) > 0) {
        $twoFa = "Auth";
    } elseif (strlen(trim($twoFaEmail)) > 0) {
        $twoFa = "Email";
    } elseif ($twoFaPGP == 'true') {
        $twoFa = 'PGP';
    }

    $resp = array(
        'token' => $token,
        'user_email' => $user->data->user_email,
        'user_nicename' => $user->data->user_nicename,
        'user_display_name' => $user->data->display_name,
        "user_id" => $user->data->ID,
        "user_role" => get_userdata($user->data->ID)->roles,
        "user_caps" => $roles,
        "user_registered" => $user->data->user_registered,
        "2fa" => $twoFa,
        "is_email_confirmed" => $email_is_confirmed,
        "profile" => $profile,
        "2authData" => ["2FAOTP" => $twoFaAuth, "2FAEMAIL" => $twoFaEmail, "2FAPGP" => $twoFaPGP]
    );
    return $resp;
}

function drk_generate_otp_code()
{
    $g = new Sonata\GoogleAuthenticator\GoogleAuthenticator();
    return $g->generateSecret();
}

function drk_generate_confirmation_code()
{
    return substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 6);
}

function drk_generate_secret_code()
{
    return substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 0, 16);
}

function drk_get_header_bearer_token(WP_REST_Request $request){
    $token = false;
    $header = $request->get_headers();
    $token = $header['authorization'][0];
    return str_replace("Bearer ","", $token);
}

function drk_get_user_id_from_token(String $token){
    $secret_key = defined('JWT_AUTH_SECRET_KEY') ? JWT_AUTH_SECRET_KEY : false;
    if(!$token)
        return wp_get_current_user()->ID;
    try {
        $decode_token = JWT::decode($token,new Key($secret_key, 'HS256'));
    } catch (Exception $e) {
        return new WP_Error('invalid_token', $e->getMessage(), array('status' => 401));
    }

    return $decode_token->data->user->id;
}