<?php
function drk_send_confirmation_on_profile_email($user_id) {
    global $errors, $wpdb;
    $current_user = get_user_by('ID', $user_id);
    if ( ! is_object($errors) )
        $errors = new WP_Error();

    if ( $current_user->ID != $_POST['user_id'] )
        return false;

    if ( $current_user->user_email != $_POST['email'] ) {
        if ( !is_email( $_POST['email'] ) ) {
            $errors->add( 'user_email', __( "<strong>ERROR</strong>: The e-mail address isn't correct." ), array( 'form-field' => 'email' ) );
            return;
        }

        if ( email_exists( $_POST['email'] ) ) {
            $errors->add( 'user_email', __( "<strong>ERROR</strong>: The e-mail address is already used." ), array( 'form-field' => 'email' ) );
            delete_user_meta( $current_user->ID . '_new_email' );
            return;
        }

        $hash = md5( $_POST['email'] . time() . mt_rand() );
        $new_user_email = array(
            'hash' => $hash,
            'newemail' => $_POST['email']
        );
        update_user_meta( $current_user->ID . '_new_email', $new_user_email );

        $content = apply_filters( 'new_user_email_content', __( "Dear user,

    You recently requested to have the email address on your account changed.
    If this is correct, please click on the following link to change it:
    ###ADMIN_URL###

    You can safely ignore and delete this email if you do not want to
    take this action.

    This email has been sent to ###EMAIL###

    Regards,
    All at ###SITENAME###
    ###SITEURL###" ), $new_user_email );

        $content = str_replace( '###ADMIN_URL###', esc_url( admin_url( 'profile.php?newuseremail='.$hash ) ), $content );
        $content = str_replace( '###EMAIL###', $_POST['email'], $content);
        $content = str_replace( '###SITENAME###', get_site_option( 'site_name' ), $content );
        $content = str_replace( '###SITEURL###', home_url(), $content );

        wp_mail( $_POST['email'], sprintf( __( '[%s] New Email Address' ), get_option( 'blogname' ) ), $content );
        $_POST['email'] = $current_user->user_email;
    }
}
add_action( 'personal_options_update', 'drk_send_confirmation_on_profile_email' );

function drk_verify_email_change($user_id, $old_user_data, $userdata ){
    global $errors, $wpdb;
    $current_user = get_user_by('ID',$user_id);
    if (in_array($GLOBALS['pagenow'], array('profile.php')) && $current_user->ID > 0) {
        if (isset( $_GET[ 'newuseremail' ] ) && $current_user->ID ) {
            $new_email = get_user_meta( $current_user->ID . '_new_email' );
            if ( $new_email[ 'hash' ] == $_GET[ 'newuseremail' ] ) {
                $user->ID = $current_user->ID;
                $user->user_email = esc_html( trim( $new_email[ 'newemail' ] ) );
                if ( $wpdb->get_var( $wpdb->prepare( "SELECT user_login FROM {$wpdb->users} WHERE user_login = %s", $current_user->user_login ) ) )
                    $wpdb->query( $wpdb->prepare( "UPDATE {$wpdb->users} SET user_email = %s WHERE user_login = %s", $user->user_email, $current_user->user_login ) );
                wp_update_user( get_object_vars( $user ) );
                delete_user_meta( $current_user->ID . '_new_email' );
                wp_redirect( add_query_arg( array('updated' => 'true'), self_admin_url( 'profile.php' ) ) );
                die();
            }
        } elseif ( !empty( $_GET['dismiss'] ) && $current_user->ID . '_new_email' == $_GET['dismiss'] ) {
            delete_user_meta( $current_user->ID . '_new_email' );
            wp_redirect( add_query_arg( array('updated' => 'true'), self_admin_url( 'profile.php' ) ) );
            die();
        }
    }
}
add_action('profile_update','drk_verify_email_change');
