<?php
add_filter( 'jwt_auth_token_before_dispatch', 'format_jwt_payload', 10, 2 );
function format_jwt_payload($token, $user){
    $email_is_confirmed = get_the_author_meta('drk_email_is_confirmed',$user->data->ID);
    $profile = drk_get_user_profile((array)$user->data);
    $roles = $user->get_role_caps();


    $data = array(
        'token' => $token["token"],
        'user_email' => $user->data->user_email,
        'user_nicename' => $user->data->user_nicename,
        'user_display_name' => $user->data->display_name,
        "user_id" => $user->data->ID,
        "user_role" => get_userdata($user->data->ID)->roles,
        "user_caps" => $roles,
        "user_registered" => $user->data->user_registered,
        "2fa" => drk_get_2fa_type($user),
        "is_email_confirmed" => $email_is_confirmed,
        "profile" => $profile
    );
    return $data;
}

