<?php
function rate_custom_rest(){

    register_rest_field(array('news','tutorials','forum'), '_rating_array', array(
            'get_callback' => function ($post, $attr, $request){
                $token = drk_get_header_bearer_token($request);
                $user_id = drk_get_user_id_from_token($token);
                return drk_get_post_votes($user_id, $post['id']);
            }
    ));
    register_rest_field(array('news','tutorials','forum'), '_rate', array(
        'get_callback' => function ($post, $attr, $request){
            $token = drk_get_header_bearer_token($request);
            $user_id = drk_get_user_id_from_token($token);
            $rating = drk_get_post_votes($user_id, $post['id']);
            update_post_meta($post['id'],'_rate',$rating['rate']);
            return $rating["rate"];
        }
    ));

    register_rest_field(array('comment'), '_rating_array', array(
        'get_callback' => function ($comment_arr, $attr, $request){
            $token = drk_get_header_bearer_token($request);
            $user_id = drk_get_user_id_from_token($token);
            return drk_get_comments_votes($user_id, $comment_arr["id"]);
        }
    ));
    register_rest_field(array('comment'), '_rate', array(
        'get_callback' => function ($comment_arr, $attr, $request){
            $token = drk_get_header_bearer_token($request);
            $user_id = drk_get_user_id_from_token($token);
            $rating = drk_get_comments_votes($user_id, $comment_arr["id"]);
            return  $rating["_rate"];
        }
    ));
}

add_action('rest_api_init', 'rate_custom_rest');