<?php
function linked_news_custom_rest()
{

    register_rest_field(array('news', 'tutorials', 'forum'), '_linked_posts', array(
        'get_callback' => function () {
            global $post;
            $tags_id = wp_get_post_tags($post->ID, array('fields' => 'ids'));
            $linked_posts = drk_get_linked_post($post->post_type, $tags_id, $post->ID);
//            wp_reset_postdata();
            return $linked_posts;

        }
    ));
}

add_action('rest_api_init', 'linked_news_custom_rest');

function drk_get_linked_post($post_type, $tags_id, $ex_post)
{
    if ($tags_id != null) {
        $args = array(
            'post_type' => $post_type,
            'tag__in' => $tags_id,
            'post__not_in' => array($ex_post)
        );
    }else{
        $args = array(
            'post_type' => $post_type,
            'post__not_in' => array($ex_post)
        );
    }
    $linked_posts = new WP_Query($args);
    $linked_posts_result = array();
    while ($linked_posts->have_posts()) {
        $linked_posts->the_post();
        array_push($linked_posts_result, array(
            'post_id' => get_the_ID(),
            'post_slug' => get_post_field('post_name', get_post()),
            'title' => get_the_title(),
            'excerpt' => get_the_excerpt(),
            'tags' => wp_get_post_tags(get_the_ID()),
            'image' => get_the_post_thumbnail_url(get_the_ID(), 'full'),
            'date' => get_the_date('c'),
            'date_gmt' => get_gmt_from_date(get_the_date('c')),
            '_views' => get_post_meta(get_the_ID(), '_views', true)
        ));
    }
    wp_reset_postdata();

    return $linked_posts_result;
}