<?php
defined('ABSPATH') or die();

function drk_chat_messages()
{
    register_rest_route('chat/v1', '/user_messages_list', [
        'methods' => 'GET',
        'callback' => 'drk_get_user_messages_lists',
        'permission_callback' => '__return_true',
    ]);

    register_rest_route('chat/v1', '/user_message', [
        'methods' => 'GET',
        'callback' => 'drk_get_user_chat',
        'permission_callback' => '__return_true',
        'args' => [
            'chat_id' => [
                'required' => true,
                'type' => 'integer',
            ]
        ]
    ]);
    register_rest_route('chat/v1', '/delete_user_message', [
        'methods' => 'DELETE',
        'callback' => 'drk_delete_user_message',
        'permission_callback' => '__return_true',
        'args' => [
            'message_id' => [
                'required' => true,
                'type' => 'integer',
            ]
        ]
    ]);
    register_rest_route('chat/v1', '/delete_room_message', [
        'methods' => 'DELETE',
        'callback' => 'drk_delete_room_message',
        'permission_callback' => '__return_true',
        'args' => [
            'message_id' => [
                'required' => true,
                'type' => 'integer',
            ]
        ]
    ]);
    register_rest_route('chat/v1', '/user_message', [
        'methods' => 'POST',
        'callback' => 'send_user_message',
        'permission_callback' => '__return_true',
        'args' => [
            'user_id' => [
                'required' => true,
                'type' => 'integer',
            ],
            'message' => [
                'required' => true,
                'type' => 'string',
            ],
            'parent_message_id' => [
                'required' => false,
                'type' => 'integer',
            ]
        ]
    ]);

    register_rest_route('chat/v1', '/room_messages', [
        'methods' => 'GET',
        'callback' => 'get_room_messages',
        'permission_callback' => '__return_true',
    ]);

    register_rest_route('chat/v1', '/room_message', [
        'methods' => 'POST',
        'callback' => 'send_room_message',
        'permission_callback' => '__return_true',
        'args' => [
            'message' => [
                'required' => true,
                'type' => 'string',
            ],
            'parent_message_id' => [
                'required' => false,
                'type' => 'integer',
            ]
        ]
    ]);
}

add_action('rest_api_init', 'drk_chat_messages');