<?php

defined('ABSPATH') or die();

function drk_validate(WP_REST_Request $request)
{
    global $error;
    $header = $request->get_headers();
    $token = drk_get_header_bearer_token($request);
    $user_id = drk_get_user_id_from_token($token);
    $token = $header['authorization'][0];
    $token = str_replace("Bearer ","", $token);
    return drk_validate_token($token, $user_id);
}

function drk_validate_rest()
{
register_rest_route('auth/v1', '/validate', [
    'methods' => 'POST',
    'callback' => 'drk_validate',
    'permission_callback' => '__return_true',
    'args' => [
        'user_id' => [
            'required' => true,
            'type' => 'integer',
        ],
    ],
]);
}
add_action('rest_api_init', 'drk_validate_rest');