<?php

function drk_confirm_email(WP_REST_Request $request)
{
    $result = array();
    $request_data = $request->get_params();
    if (strlen($request_data['code']) > 0 && strlen($request_data['email']) > 0 ) {
        $confirmation_user = get_user_by('email', $request_data['email']);
        $check_code = $request_data['code'];
        if($confirmation_user){
            $verify_code = get_user_meta($confirmation_user->ID, 'drk_email_confirmation_code',true);
            if($check_code == $verify_code){
                $result = array(
                    "is_email_send" => true,
                    "is_email_confirmed" => $check_code == $verify_code
                );
                delete_user_meta($confirmation_user->ID, 'drk_email_confirmation_code', '');
                update_user_meta($confirmation_user->ID, 'drk_email_is_confirmed', "true");
            }else{
                $result = array(
                    "is_email_send" => true,
                    "is_email_confirmed" => false,
                    "error" => "wrong_code"
                );
            }

        }else{
            $result = array(
                "is_email_send" => true,
                "is_email_confirmed" => false,
                "error" => "wrong_user"
            );
        }
    } else {
        $confirmation_code = drk_generate_confirmation_code();
        $email = urlencode($request_data['email']);
        $confirmation_user = get_user_by('email', $request_data['email']);
        if($confirmation_user){
            $email_is_send = wp_mail($request_data['email'], "You registred on Darkey. Confirm your EMAIL",
                "For confirmation got to link:<br>
            <a href='https://darkey.host/verify-email?email=$email&verify_code=$confirmation_code'>Go to Darkey. Yur code is $confirmation_code</a>
            ");
            update_user_meta($confirmation_user->ID, 'drk_email_confirmation_code', $confirmation_code);
            $result = array(
                "is_email_send" => $email_is_send
            );
        }else{
            $result = array(
                "is_email_send" => $confirmation_user
            );
        }


    }

    return $result;
}


function drk_confirm_email_rest()
{
    register_rest_route('auth/v1', '/confirm_email', [
        'methods' => 'POST',
        'callback' => 'drk_confirm_email',
        'permission_callback' => '__return_true',
        'args' => [
            'email' => [
                'required' => false,
                'type' => 'string',
            ],
            'confirmation_code' => [
                'required' => false,
                'type' => 'string',
            ],
//            'captcha' => [
//                'required' => true,
//                'validate_callback' => function ($param) {
//                    $code = crypt(trim($param), CAPTCHA_SECRET);
//                    session_start();
//
//                    $captcha = $_SESSION['captcha'];
//                    unset($_SESSION['captcha']);
//
//                    if (!$captcha) return false;
//
//                    return $captcha === $code;
//                },
//                'type' => 'string',
//            ],
        ]
    ]);
}

add_action('rest_api_init', 'drk_confirm_email_rest');