<?php
defined('ABSPATH') or die();

function drk_pcheck(WP_REST_Request $request)
{
    $password = $request->get_param('password');

    $token = drk_get_header_bearer_token($request);
    $user_id = drk_get_user_id_from_token($token);
    $user = get_user_by('ID', $user_id);

    if($user->ID == null){
        $user = get_user_by('id',$user_id);
    }

    $hash = $user->data->user_pass;
    return wp_check_password($password,$hash,$user->ID);
}

function drk_pcheck_rest()
{
    register_rest_route('auth/v1', '/pcheck', [
        'methods' => 'POST',
        'callback' => 'drk_pcheck',
        'permission_callback' => '__return_true',
        'args' => [
            'password' => [
                'required'=>true,
                'type' => 'string'
            ]
        ]
    ]);
}
add_action('rest_api_init', 'drk_pcheck_rest');