<?php

function drk_user_change_password(WP_REST_Request $request){
    $token = drk_get_header_bearer_token($request);
    $user_id = drk_get_user_id_from_token($token);

    $user = get_user_by( 'id', $user_id );
    $password = $request->get_param('password');
    $new_password = $request->get_param('new_password');

    if(empty($user_id)){
        $json = array('code'=>'0','msg'=>'Please enter user id');
        echo json_encode($json);
        exit;
    }
    if(empty($password)){
        $json = array('code'=>'0','msg'=>'Please enter old password');
        echo json_encode($json);
        exit;
    }
    if(empty($new_password)){
        $json = array('code'=>'0','msg'=>'Please enter new password');
        echo json_encode($json);
        exit;
    }
    $hash = $user->data->user_pass;

    $code = 500; $status = false;
    if (wp_check_password( $password, $hash ) ){
        $msg = 'Password updated successfully';
        $code = 200; $status = true;
        wp_set_password($new_password , $user_id);
    }else{
        $msg = 'Current password does not match.';
        return false;
    }
    $json = array('code'=>$code,'status'=>$status,'msg'=>$msg);
    return $json;
}
function drk_user_change_password_rest(){
    register_rest_route('auth/v1', '/change_user_password', [
        'methods' => 'POST',
        'callback' => 'drk_user_change_password',
        'permission_callback' => '__return_true',
        'args' => [
            'user_id' => [
                'required' => true,
                'type' => 'string',
            ],
            'password' => [
                'required' => true,
                'type' => 'email',
            ],
            'new_password' => [
                'required' => true,
                'type' => 'string',
            ],
        ]
    ]);
}

add_action('rest_api_init', 'drk_user_change_password_rest');