<?php
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
defined('ABSPATH') or die();

function drk_enable_otp(WP_REST_Request $request)
{
    $token = drk_get_header_bearer_token($request);
    $user_id = drk_get_user_id_from_token($token);
    $user = get_user_by('ID', $user_id);

    if (!$user) {
        return new WP_Error('invalid_otp', 'Not authorized', array('status' => 401));
    }

    update_user_meta($user->ID, 'drk_otp_is_active', "true");
    $secret = get_the_author_meta('user_otp_secret', $user->ID);
    if(strlen($secret)==0)
        update_user_meta($user->ID, 'user_otp_secret', drk_generate_otp_code());
    drk_enable_2fa_otp($user);
    return get_user_meta($user->ID, 'user_otp_secret', true);
}

function drk_disable_otp(WP_REST_Request $request)
{
    $token = drk_get_header_bearer_token($request);
    $user_id = drk_get_user_id_from_token($token);
    $user = get_user_by('ID', $user_id);

    if (!$user) {
        return new WP_Error('invalid_otp', 'Not authorized', array('status' => 401));
    }

    delete_user_meta($user->ID, 'user_otp_secret', '');
    delete_user_meta($user->ID, 'drk_otp_is_active', '');

    return 'ok';
}

function drk_get_otp_qrcode_rest(WP_REST_Request $request)
{
    $token = drk_get_header_bearer_token($request);
    $user_id = drk_get_user_id_from_token($token);
    $user = get_user_by('ID', $user_id);
    $secret = get_the_author_meta('user_otp_secret', $user_id);
    if (!$user) {
        return new WP_Error('invalid_otp', 'Not authorized', array('status' => 401));
    }
    $otpSecret = get_user_meta($user->ID, "user_otp_secret", true);
    $is_otp_active = get_the_author_meta('drk_otp_is_active', $user->ID);
    if ($is_otp_active != "true" && strlen($otpSecret)== 0){
        $otpSecret = drk_generate_otp_code();
        update_user_meta($user->ID, 'user_otp_secret', $otpSecret);
    }
    $url = Sonata\GoogleAuthenticator\GoogleQrUrl::generate('Darkey (' . $user->data->user_login . ')', $otpSecret);
    echo '<img src="' . $url . '" />';
}

function drk_get_otp_qrcode_admin(WP_User $user)
{
    $otpSecret = get_user_meta($user->ID, "user_otp_secret", true);
    $is_otp_active = get_user_meta('drk_otp_is_active', $user->ID, true);
    if (strlen($otpSecret) == 0 && $is_otp_active!="true"){
        $otpSecret = drk_generate_otp_code();
        update_user_meta($user->ID, 'user_otp_secret', $otpSecret);
    }
    $url = Sonata\GoogleAuthenticator\GoogleQrUrl::generate('Darkey (' . $user->data->user_login . ')', $otpSecret);
    echo '<img src="' . $url . '" />';
}

function drk_otp_verify(WP_REST_Request $request)
{
    $secret_key = defined('JWT_AUTH_SECRET_KEY') ? JWT_AUTH_SECRET_KEY : false;
    $code = $request->get_param('code');
    $body_string = $request->get_body();
    $body_json = json_decode($body_string,true);
    $token = $body_json['token'];
    try {
        $data =  JWT::decode($token,new Firebase\JWT\Key($secret_key, 'HS256'));
    } catch (Exception $e) {
        return new WP_Error('invalid_token_decode', [$e->getMessage(), "token"=> $token], array('status' => 401));
    }
    $user = get_user_by('ID', $data->data->user->id);

    if (!$user) {
        return new WP_Error('invalid_otp_user', 'Not authorized', array('status' => 401));
    }

    $otpSecret = get_user_meta($user->ID, 'user_otp_secret', true);
    if (!$otpSecret) {
        return new WP_Error('invalid_otp', 'User doesn\'t have otp secret key', array('status' => 400));
    }

    $g = new Sonata\GoogleAuthenticator\GoogleAuthenticator();
    if (!$g->checkCode($otpSecret,$code)) {
        return new WP_Error('invalid_otp', 'Invalid otp code', array('status' => 400));
    }


    $issuedAt = time();
    $notBefore = $issuedAt;
    $expire = $issuedAt + (DAY_IN_SECONDS * 7);

    $token = [
        'iss' => get_bloginfo('url'),
        'iat' => $issuedAt,
        'nbf' => $notBefore,
        'exp' => $expire,
        'data' => [
            'user' => [
                'id' => $user->ID,
            ],
        ],
    ];
    $otp_is_active = get_the_author_meta('drk_otp_is_active', $user->data->ID);
    if ($otp_is_active != true) {
        update_user_meta($user->ID, 'drk_otp_is_active', "true");
        delete_user_meta($user->ID, 'user_otp_mail_code', "");
    }
    $twoFa = drk_get_2fa_type($user);

    $email_is_confirmed = get_the_author_meta('drk_email_is_confirmed', $user->data->ID);
    $profile = drk_get_user_profile((array)$user->data);
    $roles = $user->get_role_caps();
    $new_token = $token;
    try{
        $new_token = JWT::encode($token, $secret_key,"HS256");
    }catch (Exception $error){
        return $error->getMessage();
    }
    return [
        'token' => $new_token,
        'user_email' => $user->data->user_email,
        'user_nicename' => $user->data->user_nicename,
        'user_display_name' => $user->data->display_name,
        "user_id" => $user->data->ID,
        "user_role" => get_userdata($user->data->ID)->roles,
        "user_caps" => $roles,
        "user_registered" => $user->data->user_registered,
        "2fa" => $twoFa,
        "is_email_confirmed" => $email_is_confirmed,
        "profile" => $profile
    ];
}

add_action('rest_api_init', 'get_2fa_qrcode_rest');
function get_2fa_qrcode_rest()
{

    register_rest_route('2fa/v1', '/enable', [
        'methods' => 'POST',
        'callback' => 'drk_enable_otp',
        'permission_callback' => '__return_true'
    ]);

    register_rest_route('2fa/v1', '/disable', [
        'methods' => 'POST',
        'callback' => 'drk_disable_otp',
        'permission_callback' => '__return_true'
    ]);

    register_rest_route('2fa/v1', '/qrcode', [
        'methods' => 'GET',
        'callback' => 'drk_get_otp_qrcode_rest',
        'permission_callback' => '__return_true'
    ]);

    register_rest_route('2fa/v1', '/verify', [
        'methods' => 'POST',
        'callback' => 'drk_otp_verify',
        'permission_callback' => '__return_true'
    ]);

}

add_filter('jwt_auth_token_before_dispatch', 'check_otp_is_enable', 10, 2);
function check_otp_is_enable($data, $user)
{
    $otpSecret = get_user_meta($user->ID, 'drk_otp_is_active', true);

    if ($otpSecret == "false" || !$otpSecret || $otpSecret==false) {
        return $data;
    }

    $secret_key = defined('JWT_AUTH_SECRET_KEY') ? JWT_AUTH_SECRET_KEY : false;
    $issuedAt = time();
    $notBefore = $issuedAt;
    $expire = $issuedAt + 3600;

    $token = [
        'iss' => get_bloginfo('url'),
        'iat' => $issuedAt,
        'nbf' => $notBefore,
        'exp' => $expire,
        'data' => [
            'user' => [
                'id' => $user->ID,
            ],
        ],
    ];

    $jwt = Firebase\JWT\JWT::encode($token, $secret_key ,'HS256');

    return new WP_Error('invalid_otp', 'OTP Auth is enabled', ['checker' => 'totp', 'token' => $jwt, 'status' => 403]);
}