<?php
/**
 * The plugin bootstrap file.
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://darkey.org
 * @since             1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:       Darkey Plugin
 * Plugin URI:        https://darkey.org
 * Description:       Extends for Darkey Site.
 * Version:           1.0.0
 * Author:            Some Author
 * Author URI:        https://darkey.org
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       drk
 * Domain Path:       /languages
 */

//* Don`t access this file directory

defined('ABSPATH') or die();

define('CAPTCHA_SECRET', '$1$itchief$7');
@ini_set( 'upload_max_size' , '300M' );
@ini_set( 'post_max_size', '300M');
//@ini_set( ‘upload_max_filesize’ , ‘101M’ );
//@ini_set( ‘post_max_size’, ‘102M’);
//@ini_set( ‘max_execution_time’, ‘300’ );
add_filter( 'show_admin_bar', '__return_false' );

require('vendor/autoload.php');
/*Admin menu*/
require_once(plugin_dir_path(__FILE__) . 'include/menu/admin_menu.php');

/*Users and roles, functions and capabilities*/
require_once(plugin_dir_path(__FILE__) . 'include/users/user_functions.php');
require_once(plugin_dir_path(__FILE__) . 'include/users/user_roles.php');
require_once(plugin_dir_path(__FILE__) . 'include/users/user_profile.php');
require_once(plugin_dir_path(__FILE__) . 'include/users/profile_meta.php');
require_once(plugin_dir_path(__FILE__) . 'include/users/users_fields.php');

/*Users permissions*/
require_once(plugin_dir_path(__FILE__) . 'include/api/permissions/user_permissions.php');

/*SMTP server settings*/
//require_once(plugin_dir_path(__FILE__).'SMTP/settings.php');
//require_once(plugin_dir_path(__FILE__).'SMTP/functions.php');

/*Formats*/
require_once(plugin_dir_path(__FILE__).'include/formats/token_api_format.php');

/*Chat*/
require_once(plugin_dir_path(__FILE__) . 'include/api/chat/v1/chat_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/chat/v1/chat_functions.php');

/*Functions*/
require_once(plugin_dir_path(__FILE__) . 'include/functions/token_functions.php');
require_once(plugin_dir_path(__FILE__).'include/functions/confirm_email.php');
require_once(plugin_dir_path(__FILE__).'include/functions/twoFA_functions.php');

/* Post Types*/
require_once(plugin_dir_path(__FILE__).'post_types/news.php');
require_once(plugin_dir_path(__FILE__).'post_types/marketplace.php');
require_once(plugin_dir_path(__FILE__).'post_types/vender.php');
require_once(plugin_dir_path(__FILE__).'post_types/tutorials.php');
require_once(plugin_dir_path(__FILE__).'post_types/forum.php');
require_once(plugin_dir_path(__FILE__).'post_types/top_forums.php');
require_once(plugin_dir_path(__FILE__).'post_types/telegram.php');
require_once(plugin_dir_path(__FILE__).'post_types/other_services.php');
require_once(plugin_dir_path(__FILE__).'post_types/special_pages.php');
/* Metaboxes */
require_once(plugin_dir_path(__FILE__).'include/meta_box/countries.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/telegram.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/mirror_links.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/online.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/rate.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/fake_rate.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/views.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/site.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/forum_link.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/date.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/category_images.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/additional_image.php');
//require_once(plugin_dir_path(__FILE__).'include/meta_box/additional_media.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/hot_news.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/pgp.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/comment_rating.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/video.php');
require_once(plugin_dir_path(__FILE__).'include/meta_box/audio.php');

/*Additional API payloads */
require_once(plugin_dir_path(__FILE__).'include/api/country_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/date_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/isOnline_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/mirror_links_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/rate_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/fake_rate_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/site_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/telegram_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/views_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/tag_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/author_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/additional_image_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/isHotNews_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/pgp_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/forum_link.php');
require_once(plugin_dir_path(__FILE__).'include/api/comments_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/categories_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/video_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/audio_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/linked_posts_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/search_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/users/user_api.php');
//require_once(plugin_dir_path(__FILE__).'include/api/gutenberg_api.php');
require_once(plugin_dir_path(__FILE__).'include/api/forms/application_form_functions.php');
require_once(plugin_dir_path(__FILE__).'include/api/forms/application_form_api.php');

require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/registration_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/captcha_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/2fa/v1/2fa_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/2fa/v1/email_auth_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/2fa/v1/pgp_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/forgot_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/login_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/user_email_confirm.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/validate_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/p_check.php');
require_once(plugin_dir_path(__FILE__) . 'include/api/auth/v1/change_password_api.php');
/* Cron */
require_once(plugin_dir_path(__FILE__).'include/cron/online_sites_meta_cron.php');
/* filters */
require_once(plugin_dir_path(__FILE__).'include/filters/filter.php');
/* sorting */
require_once(plugin_dir_path(__FILE__).'include/sorting/by_views.php');
require_once(plugin_dir_path(__FILE__).'include/sorting/by_comments_count.php');
require_once(plugin_dir_path(__FILE__).'include/sorting/by_reaction.php');
/*Voting functions*/
require_once(plugin_dir_path(__FILE__) . 'include/voting/comments_voting_functions.php');
require_once(plugin_dir_path(__FILE__) . 'include/voting/posts_voting_functions.php');
require_once(plugin_dir_path(__FILE__) . 'include/voting/users_voting_functions.php');

require_once(plugin_dir_path(__FILE__) . 'include/voting/comments_voting_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/voting/post_voting_api.php');
require_once(plugin_dir_path(__FILE__) . 'include/voting/users_voting_api.php');

require_once(plugin_dir_path(__FILE__) . 'include/blocks/allowed_guttenberg.php');
add_action('wp_enqueue_scripts','drk_scripts_init');
function drk_scripts_init() {
    //wp_enqueue_script( 'drk-script-js',plugin_dir_path(__FILE__).'js/script.js', array('jquery'),'1.0.0',false);
    wp_enqueue_script( 'drk-script-js', plugins_url( '/js/script.js', __FILE__ ));
}
/*Database*/
register_activation_hook(__FILE__, 'drk_create_forum_chat_table');
register_activation_hook(__FILE__, 'drk_create_user_chat_table');

register_activation_hook(__FILE__, 'drk_create_posts_voting_table');
register_activation_hook(__FILE__, 'drk_create_comments_voting_table');
register_activation_hook(__FILE__, 'drk_create_users_voting_table');

add_image_size('profile-thumb', 200, 200, true);

add_action( 'rest_api_init', function() {
    remove_filter( 'rest_pre_serve_request', 'rest_send_cors_headers' );
    add_filter( 'rest_pre_serve_request', "initCors");
}, 15 );

function initCors( $value )
{
    $origin = get_http_origin();
    $allowed_origins = [ 'admin.darkey.host', 'darkey.host', 'localhost:3000', 'localhost:8082' ];

    if ( $origin && in_array( $origin, $allowed_origins ) ) {
        header( 'Access-Control-Allow-Origin: ' . esc_url_raw( $origin ) );
        header( 'Access-Control-Allow-Methods: "GET,POST"' );
        header( 'Access-Control-Allow-Credentials: true' );
    }

    return $value;
}