<?php

function drk_top_forum_custom_post_type() {
    $labels = array(
        'name'               => __( 'Top Forum' ),
        'singular_name'      => __( 'Top Forum' ),
        'menu_name'          => __( 'Top Forum' ),
        'all_items'          => __( 'All Top Forums' ),
        'view_item'          => __( 'View Top Forum' ),
        'add_new_item'       => __( 'Add Top Forum' ),
        'add_new'            => __( 'Add Top Forum' ),
        'edit_item'          => __( 'Edit Top Forum' ),
        'update_item'        => __( 'Update Top forum' ),
        'search_items'       => __( 'Search Top forum' ),
        'not_found'          => __( 'Not Found' ),
        'not_found_in_trash' => __( 'Not found in Trash' )
    );
    $args   = array(
        'label'               => __( 'top_forum' ),
        'description'         => __( 'Top Forum' ),
        'labels'              => $labels,
        'supports'            => array(
            'title',
            'editor',
            'author',
            'thumbnail',
            'taxonomies',
            'excerpt',
            'comments'
        ),
        'public'              => true,
        'hierarchical'        => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'has_archive'         => false,
        'can_export'          => false,
        'exclude_from_search' => false,
        'yarpp_support'       => true,
        'taxonomies'          => array( 'post_tag'),
        'publicly_queryable'  => false,
        'capability_type'     => 'post',
        'menu_position' => 6,
        'menu_icon' => 'dashicons-welcome-write-blog',
        'show_in_rest'       => true
    );
    register_post_type( 'top_forums', $args );
}

add_action( 'init', 'drk_top_forum_custom_post_type', 0 );