<?php

function drk_update_custom_roles()
{

    $admin_cap = array(
        'read' => true,
        /*Start Profile caps*/
        'read_profile'=>true,
        'read_private_profiles'=>true,
        'edit_profile'=>true,
        'edit_profiles'=>true,
        'edit_others_profiles'=>true,
        'edit_published_profiles'=>true,
        'edit_private_profiles'=>true,
        'delete_profile'=>true,
        'delete_profiles'=>true,
        'delete_others_profiles'=>true,
        'delete_published_profiles'=>true,
        'delete_private_profiles'=>true,
        'publish_profiles'=>true,
        'moderate_profile_comments'=>true,
        /*End Profile caps*/
        "can_login" => true,
        "write_comments"=> true,
        "use_chats" => true,
        "use_forum"=> true,
        "use_rating" => true,
        "create_posts" => true,
        "delete_posts" => true,
        "edit_posts" => true,
        "upload_files" => true,
        "publish_posts" => true,
        "read_private_pages" => true,
        "read_private_posts"  => true,
        "delete_others_posts" => true,
        "delete_private_posts" => true,
        "delete_published_posts" => true,
        "edit_others_posts" => true,
        "edit_private_posts" => true,
        "edit_published_posts" => true,
        "manage_categories" => true,
        "manage_links" => true,
        "moderate_comments" => true,
        "activate_plugins" => true,
        "create_users" => true,
        "delete_others_pages" => true,
        "delete_pages" => true,
        "delete_plugins" => true,
        "delete_private_pages" => true,
        "delete_published_pages" => true,
        "delete_users" => true,
        "edit_dashboard" => true,
        "edit_others_pages" => true,
        "edit_pages" => true,
        "edit_private_pages" => true,
        "edit_published_pages" => true,
        "edit_users" => true,
        "install_plugins" => true,
        "list_users" => true,
        "manage_options" => true,
        "promote_users" => true,
        "publish_pages" => true,
        "remove_users" => true,
        "update_core" => true,
        "update_plugins" => true,
        "update_themes" => true
        );

    $moder_cap = array(
        /*Start Profile caps*/
        'read_profile'=>true,
        'read_private_profiles'=>true,
        'edit_profile'=>true,
        'edit_profiles'=>true,
        'edit_others_profiles'=>true,
        'edit_published_profiles'=>true,
        'edit_private_profiles'=>true,
        'delete_profile'=>true,
        'delete_profiles'=>true,
        'delete_others_profiles'=>true,
        'delete_published_profiles'=>true,
        'delete_private_profiles'=>true,
        'publish_profiles'=>true,
        'moderate_profile_comments'=>true,
        /*End Profile caps*/
        "can_login" => true,
        "write_comments"=> true,
        "use_chats" => true,
        "use_forum"=> true,
        "use_rating" => true,
        "create_posts" => true,
        "delete_posts" => true,
        "edit_posts" => true,
        "upload_files" => true,
        "publish_posts" => true,
        "read_private_pages" => true,
        "read_private_posts" => true,
        "delete_others_posts" => true,
        "delete_private_posts" => true,
        "delete_published_posts" => true,
        "edit_others_posts" => true,
        "edit_private_posts" => true,
        "edit_published_posts" => true,
        "manage_categories" => true,
        "manage_links" => true,
        "moderate_comments" => true,
        "activate_plugins" => false,
        "create_users" => false,
        "delete_others_pages" => false,
        "delete_pages" => false,
        "delete_plugins" => false,
        "delete_private_pages" => false,
        "delete_published_pages" => false,
        "delete_users" => false,
        "edit_dashboard" => false,
        "edit_others_pages" => false,
        "edit_pages" => false,
        "edit_private_pages" => false,
        "edit_published_pages" => false,
        "edit_users" => false,
        "install_plugins" => false,
        "list_users" => false,
        "manage_options" => false,
        "promote_users" => false,
        "publish_pages" => false,
        "remove_users" => false,
        "update_core" => false,
        "update_plugins" => false,
        "update_themes" => false
    );

    $vip_cap = array(
        /*Start Profile caps*/
        'read_profile'=>true,
        'read_private_profiles'=>true,
        'edit_profile'=>true,
        'edit_profiles'=>true,
        'edit_others_profiles'=>false,
        'edit_published_profiles'=>false,
        'edit_private_profiles'=>false,
        'delete_profile'=>false,
        'delete_profiles'=>false,
        'delete_others_profiles'=>false,
        'delete_published_profiles'=>false,
        'delete_private_profiles'=>false,
        'publish_profiles'=>true,
        'moderate_profile_comments'=>false,
        /*End Profile caps*/
        "can_login" => true,
        "write_comments"=> true,
        "use_chats" => true,
        "use_forum"=> true,
        "use_rating" => true,
        "create_posts" => true,
        "delete_posts" => true,
        "edit_posts" => true,
        "upload_files" => true,
        "publish_posts" => true,
        "read_private_pages" => true,
        "read_private_posts" => true,
        "delete_others_posts" => false,
        "delete_private_posts" => false,
        "delete_published_posts" => false,
        "edit_others_posts" => false,
        "edit_private_posts" => false,
        "edit_published_posts" => false,
        "manage_categories" => false,
        "manage_links" => false,
        "moderate_comments" => false,
        "activate_plugins" => false,
        "create_users" => false,
        "delete_others_pages" => false,
        "delete_pages" => false,
        "delete_plugins" => false,
        "delete_private_pages" => false,
        "delete_published_pages" => false,
        "delete_users" => false,
        "edit_dashboard" => false,
        "edit_others_pages" => false,
        "edit_pages" => false,
        "edit_private_pages" => false,
        "edit_published_pages" => false,
        "edit_users" => false,
        "install_plugins" => false,
        "list_users" => false,
        "manage_options" => false,
        "promote_users" => false,
        "publish_pages" => false,
        "remove_users" => false,
        "update_core" => false,
        "update_plugins" => false,
        "update_themes" => false
    );

    $seller_cap = array(
        /*Start Profile caps*/
        'read_profile'=>true,
        'read_private_profiles'=>true,
        'edit_profile'=>true,
        'edit_profiles'=>true,
        'edit_others_profiles'=>false,
        'edit_published_profiles'=>false,
        'edit_private_profiles'=>false,
        'delete_profile'=>false,
        'delete_profiles'=>false,
        'delete_others_profiles'=>false,
        'delete_published_profiles'=>false,
        'delete_private_profiles'=>false,
        'publish_profiles'=>true,
        'moderate_profile_comments'=>false,
        /*End Profile caps*/
        "can_login" => true,
        "write_comments"=> true,
        "use_chats" => true,
        "use_forum"=> true,
        "use_rating" => true,
        "create_posts" => true,
        "delete_posts" => true,
        "edit_posts" => true,
        "upload_files" => true,
        "publish_posts" => false,
        "read_private_pages" => false,
        "read_private_posts"  => false,
        "delete_others_posts" => false,
        "delete_private_posts" => false,
        "delete_published_posts" => false,
        "edit_others_posts" => false,
        "edit_private_posts" => false,
        "edit_published_posts" => false,
        "manage_categories" => false,
        "manage_links" => false,
        "moderate_comments" => false,
        "activate_plugins" => false,
        "create_users" => false,
        "delete_others_pages" => false,
        "delete_pages" => false,
        "delete_plugins" => false,
        "delete_private_pages" => false,
        "delete_published_pages" => false,
        "delete_users" => false,
        "edit_dashboard" => false,
        "edit_others_pages" => false,
        "edit_pages" => false,
        "edit_private_pages" => false,
        "edit_published_pages" => false,
        "edit_users" => false,
        "install_plugins" => false,
        "list_users" => false,
        "manage_options" => false,
        "promote_users" => false,
        "publish_pages" => false,
        "remove_users" => false,
        "update_core" => false,
        "update_plugins" => false,
        "update_themes" => false
    );

    $user_cap = array(
        /*Start Profile caps*/
        'read_profile'=>true,
        'read_private_profiles'=>true,
        'edit_profile'=>true,
        'edit_profiles'=>true,
        'edit_others_profiles'=>false,
        'edit_published_profiles'=>true,
        'edit_private_profiles'=>true,
        'delete_profile'=>false,
        'delete_profiles'=>false,
        'delete_others_profiles'=>false,
        'delete_published_profiles'=>false,
        'delete_private_profiles'=>false,
        'publish_profiles'=>true,
        'moderate_profile_comments'=>false,
        /*End Profile caps*/
        "can_login" => true,
        "write_comments"=> true,
        "use_chats" => true,
        "use_forum"=> true,
        "use_rating" => true,
        "create_posts" => false,
        "delete_posts" => false,
        "edit_posts" => false,
        "upload_files" => true,
        "publish_posts" => false,
        "read_private_pages" => false,
        "read_private_posts"  => false,
        "delete_others_posts" => false,
        "delete_private_posts" => false,
        "delete_published_posts" => false,
        "edit_others_posts" => false,
        "edit_private_posts" => false,
        "edit_published_posts" => false,
        "manage_categories" => false,
        "manage_links" => false,
        "moderate_comments" => false,
        "activate_plugins" => false,
        "create_users" => false,
        "delete_others_pages" => false,
        "delete_pages" => false,
        "delete_plugins" => false,
        "delete_private_pages" => false,
        "delete_published_pages" => false,
        "delete_users" => false,
        "edit_dashboard" => false,
        "edit_others_pages" => false,
        "edit_pages" => false,
        "edit_private_pages" => false,
        "edit_published_pages" => false,
        "edit_users" => false,
        "install_plugins" => false,
        "list_users" => false,
        "manage_options" => false,
        "promote_users" => false,
        "publish_pages" => false,
        "remove_users" => false,
        "update_core" => false,
        "update_plugins" => false,
        "update_themes" => false
    );

    $banned_cap = array(
        /*Start Profile caps*/
        'read_profile'=>false,
        'read_private_profiles'=>false,
        'edit_profile'=>false,
        'edit_profiles'=>false,
        'edit_others_profiles'=>false,
        'edit_published_profiles'=>false,
        'edit_private_profiles'=>false,
        'delete_profile'=>false,
        'delete_profiles'=>false,
        'delete_others_profiles'=>false,
        'delete_published_profiles'=>false,
        'delete_private_profiles'=>false,
        'publish_profiles'=>true,
        'moderate_profile_comments'=>false,
        /*End Profile caps*/
        "can_login" => false,
        "show_admin_bar" => false,
        "view_admin_dashboard"=> false,
        "write_comments"=> false,
        "use_chats" => false,
        "use_forum"=> false,
        "use_rating" => false,
        "read" => false,
        "create_posts" => false,
        "delete_posts" => false,
        "edit_posts" => false,
        "upload_files" => false,
        "publish_posts" => false,
        "read_private_pages" => false,
        "read_private_posts"  => false,
        "delete_others_posts" => false,
        "delete_private_posts" => false,
        "delete_published_posts" => false,
        "edit_others_posts" => false,
        "edit_private_posts" => false,
        "edit_published_posts" => false,
        "manage_categories" => false,
        "manage_links" => false,
        "moderate_comments" => false,
        "activate_plugins" => false,
        "create_users" => false,
        "delete_others_pages" => false,
        "delete_pages" => false,
        "delete_plugins" => false,
        "delete_private_pages" => false,
        "delete_published_pages" => false,
        "delete_users" => false,
        "edit_dashboard" => false,
        "edit_others_pages" => false,
        "edit_pages" => false,
        "edit_private_pages" => false,
        "edit_published_pages" => false,
        "edit_users" => false,
        "install_plugins" => false,
        "list_users" => false,
        "manage_options" => false,
        "promote_users" => false,
        "publish_pages" => false,
        "remove_users" => false,
        "update_core" => false,
        "update_plugins" => false,
        "update_themes" => false
    );
    $roles_array = array(
        array("role" => "vip", "name" => "VIP","cap" => $vip_cap),
        array("role" => "service", "name" => "SERVICE", "cap" => $moder_cap),
        array("role" => "seller", "name" => "SELLER", "cap" => $seller_cap),
        array("role" => "moder", "name" => "MODER", "cap" => $moder_cap ),
        array("role" => "user", "name" => "USER", "cap" => $user_cap),
        array("role" => "user_problems", "name" => "USER PROBLEMS", "cap" => $user_cap),
        array("role" => "banned", "name" => "BANNED", "cap" => $banned_cap),
    );
    foreach ($roles_array as $role) {
        remove_role($role['role']);
    }
    foreach ($roles_array as $role) {
        add_role($role['role'], $role['name'], $role['cap']);
    }

    update_option('default_role', 'user');
    update_option('permalink_structure', '/%postname%/');
}

add_action('init', 'drk_update_custom_roles');

function drk_admin_caps()
{
    $admin_role = get_role('administrator');
    $admin_role->add_cap( 'edit_profile',true);
    $admin_role->add_cap( 'read_profile',true );
    $admin_role->add_cap( 'delete_profile', true );
    $admin_role->add_cap( 'edit_profiles',true);
    $admin_role->add_cap( 'edit_others_profiles',true);
    $admin_role->add_cap( 'publish_profiles',true );
    $admin_role->add_cap( 'read_private_profiles', true );
    $admin_role->add_cap( 'read', true );
    $admin_role->add_cap( 'delete_profiles', true );
    $admin_role->add_cap( 'delete_private_profiles', true );
    $admin_role->add_cap( 'delete_published_profiles', true );
    $admin_role->add_cap( 'delete_others_profiles', true );
    $admin_role->add_cap( 'edit_private_profiles', true );
    $admin_role->add_cap( 'edit_published_profiles', true );
    $admin_role->add_cap( 'create_private_profiles', true );
}
add_action('admin_init', 'drk_admin_caps');