<?php

function drk_profile_custom_post_type()
{
    $labels = array(
        'name' => __('Profiles'),
        'singular_name' => __('Profile'),
        'menu_name' => __('Profiles'),
        'all_items' => __('All profiles'),
        'view_item' => __('View profile'),
        'add_new_item' => __('Add profile'),
        'add_new' => __('Add profile'),
        'edit_item' => __('Edit profile'),
        'update_item' => __('Update profile'),
        'search_items' => __('Search profile'),
        'not_found' => __('Not Found'),
        'not_found_in_trash' => __('Not found in Trash')
    );
    $args = array(
        'label' => __('Profile'),
        'description' => __('Profiles'),
        'labels' => $labels,
        'supports' => array(
            'title',
            'thumbnail',
            'comments'
        ),
        'public' => false,
        'hierarchical' => false,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_nav_menus' => true,
        'show_in_admin_bar' => true,
        'has_archive' => false,
        'can_export' => false,
        'exclude_from_search' => true,
        'yarpp_support' => true,
        'publicly_queryable' => false,
        'menu_position' => 5,
        'menu_icon' => "dashicons-admin-users",
        'show_in_rest' => true,
        'capabilities' => drk_compile_post_type_capabilities("profile","profiles"),
        'map_meta_cap' => true,
    );
    register_post_type('profile', $args);
}

add_action('init', 'drk_profile_custom_post_type', 0);

function drk_generate_profile_menu() {
    add_users_page(
        __( 'Generate Profile', 'drk' ),
        __( 'Generate profile', 'drk' ),
        'read',
        '',
        'drk_generate_users_profile'
    );
}
add_action('admin_menu', 'drk_generate_profile_menu');
add_action('init', 'drk_profile_custom_post_type', 0);

function shapeSpace_filter_search(WP_Query $query) {
    if ($query->is_search()) {
        $query->set('post_type', array('forum'));
    }
    return $query;
}
add_filter('pre_get_posts', 'shapeSpace_filter_search');