<?php
// Add Meta Box to post
add_action( 'add_meta_boxes', 'drk_video_uploader_meta_box' );

function drk_video_uploader_meta_box() {
	add_meta_box( 
		'video-meta-box', 
		'Video', 
		'drk_video_uploader_meta_box_func', 
		array("forum"), 
		'normal', 
		'high' );
}

function drk_video_uploader_meta_box_func($post) {
	$video = get_post_meta($post->ID,'_video',true);
	?>
	<style type="text/css">
		.multi-upload-medias ul li .delete-img { position: absolute; right: 3px; top: 2px; background: aliceblue; border-radius: 50%; cursor: pointer; font-size: 14px; line-height: 20px; color: red; }
		.multi-upload-medias ul li { width: 120px; display: inline-block; vertical-align: middle; margin: 5px; position: relative; }
		.multi-upload-medias ul li img { width: 100%; }
	</style>

	<table cellspacing="10" cellpadding="10">
		<tr>
			<td>Add Video</td>
			<td>
				<?php echo drk_video_uploader_field( '_video', $video ); ?>
			</td>
		</tr>
	</table>

	<script type="text/javascript">
		jQuery(function($) {

			$('body').on('click', '.drk_video_upload_button', function(e) {
				e.preventDefault();
				var button = $(this),
				custom_uploader = wp.media({
					title: 'Insert video',
					button: { text: 'Use this video' },
					multiple: false,
					library: { type: ['video']},
				}).on('select', function() {
					var attech_ids = '';
					//attachments
					var attachments = custom_uploader.state().get('selection'),
					attachment_ids = new Array(),
					i = 0;
					attachments.each(function(attachment) {
						attachment_ids[i] = attachment['id'];
						attech_ids += ',' + attachment['id'];
						console.log(attachment.attributes.type);
						if(attachment.attributes.type == 'video')
							$(button).siblings('ul').append('<video width="320" height="240" controls><source src="'+ attachment.attributes.url +'" type="video/mp4">Your browser does not support the video tag.</video><i class=" dashicons dashicons-no delete-img"></i>');
						i++;
					});

					var ids = $(button).siblings('.attechments-ids').attr('value');
					if (ids) {
						var ids = ids + attech_ids;
						$(button).siblings('.attechments-ids').attr('value', ids);
					} else {
						$(button).siblings('.attechments-ids').attr('value', attachment_ids);
					}
					$(button).siblings('.wc_multi_remove_image_button').show();
				})
				.open();
			});

			$('body').on('click', '.wc_multi_remove_image_button', function() {
				$(this).hide().prev().val('').prev().addClass('button').html('Add video');
				$(this).parent().find('ul').empty();
				return false;
			});

		});

		jQuery(document).ready(function() {
			jQuery(document).on('click', '.multi-upload-medias ul li i.delete-img', function() {
				var ids = [];
				var this_c = jQuery(this);
				jQuery(this).parent().remove();
				jQuery('.multi-upload-medias ul li').each(function() {
					ids.push(jQuery(this).attr('data-attechment-id'));
				});
				jQuery('.multi-upload-medias').find('input[type="hidden"]').attr('value', ids);
			});
		})
	</script>

	<?php
}


function drk_video_uploader_field($name, $value = '') {
	$video = '">Add video';
	$video_str = '';
	$video_size = 'full';
	$display = 'none';
	//$value = explode(',', $value);
	

	if (!empty($value)) {
		if ($video_attributes = wp_get_attachment_url($value) ) {
			$video_str .= "<video width='320' height='240' controls><source src='"
			.$video_attributes.
			"' type='video/mp4'>Your browser does not support the video tag.</video>";
		}
	}

	if($video_str){
		$display = 'inline-block';
	}

	return '<div class="multi-upload-medias"><ul>' . $video_str . '</ul><a href="#" class="drk_video_upload_button button' 
	. $video . '</a><input type="hidden" class="attechments-ids ' . $name . '" name="' . $name . '" id="' . $name . '" value="' 
	. esc_attr($value) . '" /><a href="#" class="wc_multi_remove_image_button button" style="display:inline-block;display:' 
	. $display . '">Remove media</a></div>';
}

// Save Meta Box values.
add_action( 'save_post', 'drk_video_meta_box_save' );

function drk_video_meta_box_save( $post_id ) {
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;	
	}

	if( !current_user_can( 'edit_post' ) ){
		return;	
	}
	
	if( isset( $_POST['_video'] ) ){
		update_post_meta( $post_id, '_video', $_POST['_video'] );
	}
}