<?php

	add_action( 'add_meta_boxes','drk_add_comment_rating' );
	function drk_add_comment_rating()
	{
		add_meta_box(
			 'comments_rating',
			__( 'Comments Rating' ),
			'drk_comment_rating_metabox',
			'comment',
			'normal'
		);
	}

	function drk_comment_rating_metabox( $comment )
	{
		$stars = 0;
		$rate_value = intval(get_comment_meta($comment->comment_ID, '_rate',true));
        $voted_stars = intval(get_comment_meta($comment->comment_ID, '_rate_stars',true));
        $vote_count = intval(get_comment_meta($comment->comment_ID, '_vote_count',true));
		?>
        <h4>Rating: <b><?php echo $rate_value?></b></h4>
        <h4>Vote count: <b><?php echo $vote_count?></b></h4>
        <h4>Stars: <b><?php echo $voted_stars==0?5:$voted_stars;?> / 10</b></h4>

	<?php


	}