<?php

function drk_add_fields_to_search()
{
    register_rest_field('search-result', 'date', array(
        'get_callback' => function ($post_arr) {
            $date = get_post_field('post_date', $post_arr['id'], 'raw');
            return $date;
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', 'excerpt', array(
        'get_callback' => function ($post_arr) {
            $exerpt['rendered'] = get_the_excerpt($post_arr['id']);
            return $exerpt;
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_img', array(
        'get_callback' => function ($post_arr) {
            $post_img_id = get_post_thumbnail_id($post_arr['id']);
            $post_img = wp_get_attachment_image_src($post_img_id, 'full_size');
            if (isset($post_img[0]))
                return $post_img[0];

            return false;
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_additional_img', array(
        'get_callback' => function ($post_arr) {
            $post_additional_img = get_post_meta($post_arr['id'], '_additional_img', true);
            $additional_img = wp_get_original_image_url($post_additional_img);
            return $additional_img;
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_comments_count', array(
        'get_callback' => function ($post_arr) {
            return get_post_field('comment_count', $post_arr['id'], 'raw');
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', 'views', array(
        'get_callback' => function ($post_arr) {
            return get_post_field('_views', $post_arr['id'], 'raw');
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', 'tags', array(
        'get_callback' => function ($post_arr) {
            return wp_get_post_tags($post_arr['id']);
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', 'category', array(
        'get_callback' => function ($post_arr) {
            return wp_get_post_categories($post_arr['id'], array('fields' => 'all'));
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_country_code', array(
        'get_callback' => function ($post_arr) {
            return get_post_field('_country_code', $post_arr['id'], 'raw');
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_rate', array(
        'get_callback' => function ($post_arr) {
            return get_post_field('_rate', $post_arr['id'], 'raw');
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_stars', array(
        'get_callback' => function ($post_arr) {
            return get_post_field('_stars', $post_arr['id'], 'raw');
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_vote_count', array(
        'get_callback' => function ($post_arr) {
            return get_post_field('_vote_count', $post_arr['id'], 'raw');
        },
        'update_callback' => null,
        'schema' => null
    ));
    register_rest_field('search-result', '_author', array(
        'get_callback' => function ($post_arr) {
            $author_id = get_post_field('post_author', $post_arr['id']);
            return drk_get_author_info($author_id);
        },
        'update_callback' => null,
        'schema' => null
    ));
}

add_action('rest_api_init', 'drk_add_fields_to_search');


function map_search_order_qv(WP_Query $wp_query)
{
    if ($wp_query->is_search()) {
        if (isset($_GET['views'])) {
            $meta_value = $_GET['views'];
            $wp_query->set('meta_key', '_views');
            $wp_query->set('orderby', 'meta_value_num');
            if ($meta_value == 'asc') {
                $wp_query->set('order', 'asc');
            } elseif ($meta_value == 'desc') {
                $wp_query->set('order', 'desc');
            }
        } elseif (isset($_GET["reactions"])) {
            $meta_value = $_GET['reactions'];
            $wp_query->set('meta_key', '_vote_count');
            $wp_query->set('orderby', 'meta_value_num');
            if ($meta_value == 'asc') {
                $wp_query->set('order', 'asc');
            } elseif ($meta_value == 'desc') {
                $wp_query->set('order', 'desc');
            }
        } elseif (isset($_GET['comments_count'])) {
            $meta_value = $_GET['comments_count'];
            $wp_query->set('orderby', 'comment_count');
            $wp_query->set('key', 'comments_count');
            if ($meta_value == 'asc') {
                $wp_query->set('order', 'asc');
            } elseif ($meta_value == 'desc') {
                $wp_query->set('order', 'desc');
            }
        } elseif (isset($_GET['date'])) {
            $meta_value = $_GET['date'];
            $wp_query->set('orderby', 'date');
            $wp_query->set('key', 'date');
            if ($meta_value == 'asc') {
                $wp_query->set('order', 'asc');
            } elseif ($meta_value == 'desc') {
                $wp_query->set('order', 'desc');
            }
        }
    }
    /*serach with tags or categories*/
    $tax_query = array('relation'  => 'OR');
    if (isset($_GET["search_tags"])) {
        $meta_value = $_GET['search_tags'];
        if (is_array($meta_value)) {
            $meta_value = implode(',', $meta_value);
        }
        $tax_query[] = array(
            'taxonomy' => 'post_tag',
            'field' => 'term_id',
            'terms' => $meta_value,
            'operator' => 'IN'
        );
        $wp_query->set('tax_query',$tax_query);
        $wp_query->fields('all');
    }

    if (isset($_GET["search_categories"])) {

        $meta_value = $_GET['search_categories'];
        if (is_array($meta_value)) {
            $meta_value = implode(',', $meta_value);
        }

        $tax_query[] = array(
            'taxonomy' => 'category',
            'field' => 'term_id',
            'terms' => $meta_value,
            'operator' => 'IN'
        );
        $wp_query->set('tax_query',$tax_query);
        $wp_query->fields('all');
    }

}

add_action('parse_query', 'map_search_order_qv');
