<?php
/*Add comments to post_type response*/
function comments_rest(){
    register_rest_field( array("news", "markets",'tutorials',"forum","venders","top_forums"), "_comments_count", array(
        'get_callback' => function(){
            global $post;
            $comment_count = get_comments_number( $post->ID );
            wp_reset_postdata();
            return $comment_count;
        }
    ));

    register_rest_field( array("news", "markets",'tutorials',"forum","venders","top_forums"), "_comments_data", array(
        'get_callback' => function(){
            global $post;
            $args = array(
                'post_id' => $post->ID,
                'count' => false 
            );
            $comments = get_comments( $args );
            foreach($comments as $key=>$comment){
                $user_id = get_user_by( 'email', $comment->comment_author_email )->ID;
                $avatar = drk_get_user_avatar_from_profile($user_id);
                $comment->comment_author_avatar_url = $avatar;
                $comment->author_roles = get_userdata($user_id)->roles;
            }

            wp_reset_postdata();
            return $comments;
        }
    ));
}

add_action('rest_api_init', 'comments_rest');

/*Last comments REST API request*/
function drk_get_last_comments( WP_REST_Request $request){
    $args = array(
        'parent' => 0,
        'post_type' => $request['post_type'],
        'number' => '5',
        'orderby' => 'date',
        'order' => 'DESC'
    );
    $comments = get_comments($args);
    foreach ($comments as $comment){
        $author = get_user_by('login',$comment->comment_author);
        $comment->_user_roles = $author->roles;
        $comment->_user_avatar = drk_get_user_avatar_from_profile($author->ID);
        $user = wp_get_current_user();
        $rate = drk_get_comments_votes($user->ID,$comment->comment_ID);
        $comment->_rating_array = $rate;
        $comment->_rate = $rate['_rate'];
    }
    return $comments;
}

add_action( 'rest_api_init', function () {
    register_rest_route( 'wp/v2', '/comments/last/', array(
        'methods' => 'GET',
        'callback' => 'drk_get_last_comments',
        'permission_callback' => false
    ) );
} );

function comments_additional_fields(){
    register_rest_field( array("comment"), "_user_roles", array(
        'get_callback' => function($comment_arr){
            $author_name = $comment_arr["author_name"];
            $author = get_user_by('login',$author_name);
            return $author->roles ;
        }
    ));

    register_rest_field(array("comment"),"user_caps", array(
        'get_callback' => function($comment_arr){
            $author_name = $comment_arr["author_name"];
            $author = get_user_by('login',$author_name);
            return $author->allcaps;
        }
    ));

    register_rest_field( array("comment"), "_user_avatar", array(
        'get_callback' => function($comment_arr){
            $author_name = $comment_arr["author_name"];
            $author = get_user_by('login',$author_name);
            return drk_get_user_avatar_from_profile($author->ID);
        }
    ));
}

add_action('rest_api_init', 'comments_additional_fields');