<?php

function drk_get_author_info($authorID)
{
    $arAuthorFields = array(
        "ID" => $authorID,
        "display_name" => get_the_author_meta('display_name', $authorID),
        "first_name" => get_the_author_meta('first_name', $authorID),
        "last_name" => get_the_author_meta('last_name', $authorID),
        "nickname" => get_the_author_meta('nickname', $authorID),
        "user_firstname" => get_the_author_meta('user_firstname', $authorID),
        "user_lastname" => get_the_author_meta('user_lastname', $authorID),
        "avatar" => drk_get_user_avatar_from_profile($authorID),
        "roles" => get_userdata($authorID)->roles
    );

    return $arAuthorFields;
}

function author_custom_rest(){
    register_rest_field(array("news", "markets",'tutorials','venders', 'forum','top_forums'), '_author', array(
        'get_callback' => function (){
            global $post;
            $author = drk_get_author_info($post->post_author);
            wp_reset_postdata();
            return $author;
        }
));
}
add_action('rest_api_init', 'author_custom_rest' );