<?php

defined('ABSPATH') or die();

function send_change_password_link($request)
{
    $secret_key = defined('JWT_AUTH_SECRET_KEY') ? JWT_AUTH_SECRET_KEY : false;

    $user = get_user_by('email', $request->get_param('email'));

    if (!$user) {
        return new WP_Error('invalid_email', 'Not found', array('status' => 404));
    }

    $issuedAt = time();
    $notBefore = $issuedAt;
    $expire = $issuedAt + DAY_IN_SECONDS;

    $token = [
        'iss' => get_bloginfo('url'),
        'iat' => $issuedAt,
        'nbf' => $notBefore,
        'exp' => $expire,
        'data' => [
            'user' => [
                'id' => $user->id,
            ],
        ],
    ];

    $jwt = Firebase\JWT\JWT::encode($token, $secret_key . 'verify','HS256');

    wp_mail($user->data->user_email, 'Darkey: Reset password token', $jwt);

    return ['status' => 'ok'];
}

function change_password($request)
{
    $secret_key = defined('JWT_AUTH_SECRET_KEY') ? JWT_AUTH_SECRET_KEY : false;

    $token = $request->get_param('token');

    try {
        $data = Firebase\JWT\JWT::decode($token, $secret_key . 'verify', ['HS256']);
    } catch (Exception $e) {
        return new WP_Error('invalid_token', $e->getMessage(), array('status' => 401));
    }

    $user = get_user_by('ID', $data->data->user->id);

    if (!$user) {
        return new WP_Error('invalid_otp', 'Not authorized', array('status' => 401));
    }

    wp_set_password($request->get_param('password'), $data->data->user->id);

    return ['status' => 'ok'];
}

add_action('rest_api_init', 'get_change_password_rest');
function get_change_password_rest()
{

    register_rest_route('auth/v1', '/change-password-send', [
        'methods' => 'POST',
        'callback' => 'send_change_password_link',
        'permission_callback' => '__return_true',
        'args' => [
            'email' => [
                'required' => true,
                'type' => 'email',
            ],
            'captcha' => [
                'required' => true,
                'validate_callback' => function ($param) {
                    $code = crypt(trim($param), CAPTCHA_SECRET);
                    session_start();

                    $captcha = $_SESSION['captcha'];
                    unset($_SESSION['captcha']);

                    if (!$captcha) return false;

                    return $captcha === $code;
                },
                'type' => 'string',
            ],
        ]
    ]);

    register_rest_route('auth/v1', '/change-password-approve', [
        'methods' => 'POST',
        'callback' => 'change_password',
        'permission_callback' => '__return_true',
        'args' => [
            'token' => [
                'required' => true,
                'type' => 'string',
            ],
            'password' => [
                'required' => true,
                'type' => 'string',
            ],
        ]
    ]);

}